% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper-tools.R
\name{find_wrapper}
\alias{find_wrapper}
\title{find wrapper file}
\usage{
find_wrapper(article_dir)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}
}
\value{
wrapper file name or empty string if none
}
\description{
Finds a different named wrapper file for RJournal article
}
\examples{
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
texor::find_wrapper(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
