% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textSimilarityMatrix}
\alias{textSimilarityMatrix}
\title{Compute semantic similarity scores between all combinations in a word embedding}
\usage{
textSimilarityMatrix(x, method = "cosine", center = TRUE, scale = FALSE)
}
\arguments{
\item{x}{Word embeddings from textEmbed.}

\item{method}{(character) Character string describing type of measure to be computed. Default is "cosine" (see also
"spearmen", "pearson" as well as measures from textDistance() (which here is computed as 1 - textDistance)
including "euclidean", "maximum", "manhattan", "canberra", "binary" and "minkowski").}

\item{center}{(boolean; from base::scale) If center is TRUE then centering is done by subtracting the column means
(omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.}

\item{scale}{(boolean; from base::scale) If scale is TRUE then scaling is done by dividing the (centered)
columns of x by their standard deviations if center is TRUE, and the root mean square otherwise.}
}
\value{
A matrix of semantic similarity scores
}
\description{
Compute semantic similarity scores between all combinations in a word embedding
}
\examples{
similarity_scores <- textSimilarityMatrix(word_embeddings_4$texts$harmonytext[1:3, ])
round(similarity_scores, 3)
}
\seealso{
see \code{\link{textSimilarityNorm}}
}
