% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_wide.R
\name{longer}
\alias{longer}
\alias{wider}
\title{Pivot data between long and wide}
\usage{
longer(.data, ..., name = "name", value = "value", na.rm = FALSE)

wider(.data, ..., name, value = NULL, fun = NULL, fill = NA)
}
\arguments{
\item{.data}{A data.table}

\item{...}{Columns for unchanged group. Flexible, see examples.}

\item{name}{Name for the measured variable names column.}

\item{value}{Name for the data values column(s).}

\item{na.rm}{If \code{TRUE}, \code{NA} values will be removed from the molten data.}

\item{fun}{Should the data be aggregated before casting?
Defaults to \code{NULL}, which uses \code{length} for aggregation.
If a function is provided, with aggregated by this function.}

\item{fill}{Value with which to fill missing cells. Default uses \code{NA}.}
}
\value{
A data.table
}
\description{
Fast table pivoting from long to wide and from wide to long.
These functions are supported by \code{dcast.data.table} and \code{melt.data.table}
from \pkg{data.table}.
}
\examples{

stocks <- data.table(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)

stocks \%>\% longer(time)
stocks \%>\% longer(-(2:4)) # same
stocks \%>\% longer(-"X|Y|Z") # same
long_stocks = longer(stocks,"ti") # same as above except for assignment

long_stocks \%>\% wider(time,name = "name",value = "value")

# the unchanged group could be missed if all the rest will be used
long_stocks \%>\% wider(name = "name",value = "value")

}
\seealso{
\code{\link[tidyfst]{longer_dt}},\code{\link[tidyfst]{wider_dt}}
}
