% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{replace_vars}
\alias{replace_vars}
\title{Fast value replacement in data frame}
\usage{
replace_vars(.data, ..., from = is.na, to)
}
\arguments{
\item{.data}{A data.table}

\item{...}{Colunms to be replaced. If not specified, use all columns.}

\item{from}{A value, a vector of values or a function returns a logical value.
Defaults to \code{NaN}.}

\item{to}{A value.}
}
\value{
A data.table.
}
\description{
\code{replace_vars} could replace any value(s) or values
that match specific patterns to another specific value in a data.table.
}
\examples{
 iris \%>\% as.data.table() \%>\%
   mutate(Species = as.character(Species))-> new_iris

 new_iris \%>\%
   replace_vars(Species, from = "setosa",to = "SS")
 new_iris \%>\%
   replace_vars(Species,from = c("setosa","virginica"),to = "sv")
 new_iris \%>\%
   replace_vars(Petal.Width, from = .2,to = 2)
 new_iris \%>\%
   replace_vars(from = .2,to = NA)
 new_iris \%>\%
   replace_vars(is.numeric, from = function(x) x > 3, to = 9999 )

}
\seealso{
\code{\link[tidyfst]{replace_dt}}
}
