% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tidygam.diff}
\alias{plot.tidygam.diff}
\title{Plot methods for tidygam.diff objects}
\usage{
\method{plot}{tidygam.diff}(x, ..., sig = TRUE, sig_col = "red", sig_alpha = 0.25)
}
\arguments{
\item{x}{A \code{tidygam.diff} object (see \code{\link[=get_difference]{get_difference()}}).}

\item{...}{Arguments passed to \code{plot()}.}

\item{sig}{Shade the interval(s) where the difference smooth does not include 0 (default is \code{TRUE}).}

\item{sig_col}{Colour for the shading (default is \code{"red"}).}

\item{sig_alpha}{Alpha level for the shading (default is \code{0.25})}
}
\value{
A \code{ggplot} object.
}
\description{
Plotting methods for \code{tidygam.diff} objects.
}
\examples{
library(mgcv)
set.seed(10)
data <- gamSim(4)
model <- gam(y ~ s(x2, by = fac) + s(x0), data = data)

model_diff <- get_difference(model, "x2", list(fac = c("1", "2")))
plot(model_diff)
}
