% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_lambda}
\alias{calc_lambda}
\title{Calculate a matrix whose rows represent P(topic_i|tokens)}
\usage{
calc_lambda(beta, theta, p_docs = NULL, correct = TRUE)
}
\arguments{
\item{beta}{a beta matrix}

\item{theta}{a theta matrix}

\item{p_docs}{A numeric vector of length \code{nrow(theta)} that is
proportional to the number of terms in each document,  defaults to NULL.}

\item{correct}{Logical. Do you want to set NAs or NaNs in the final result to
zero? Useful when hitting computational underflow. Defaults to \code{TRUE}.
Set to \code{FALSE} for troubleshooting or diagnostics.}
}
\value{
Returns a \code{matrix} whose rows correspond to topics and whose columns
correspond to tokens. The i,j entry corresponds to P(topic_i|token_j)
}
\description{
Use Bayes' rule to get P(topic|token) from the estimated parameters of a
probabilistic topic model.This resulting "lambda" matrix can be used for
classifying new documents in a frequentist context and supports
\code{\link[tidylda]{augment}}.
}
\keyword{internal}
