% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat-themes.R
\name{rotated_facet_labels}
\alias{rotated_facet_labels}
\alias{rotated_axis_labels}
\title{Common plot modifications for stratigraphic plots}
\usage{
rotated_facet_labels(
  angle = 45,
  direction = "x",
  remove_label_background = TRUE
)

rotated_axis_labels(angle = 90, direction = "x")
}
\arguments{
\item{angle}{The angle at which labels should be rotated}

\item{direction}{The axes along which the operations should be performed}

\item{remove_label_background}{Whether or not label backgrounds should be removed along
rotated label axes}
}
\value{
An object or list of objects that can be added to a \link[ggplot2:ggplot]{ggplot}
}
\description{
Common plot modifications for stratigraphic plots
}
\examples{
library(ggplot2)

ggplot(mpg, aes(cty, hwy)) +
  geom_point() +
  facet_wrap(vars(class)) +
  rotated_facet_labels(45, "x")

}
