% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.R
\name{remove_y_axis}
\alias{remove_y_axis}
\alias{remove_y_axis_line}
\alias{remove_y_axis_ticks}
\alias{remove_y_axis_labels}
\alias{remove_y_axis_title}
\title{Remove y-axis or parts of it}
\usage{
remove_y_axis(plot)

remove_y_axis_line(plot)

remove_y_axis_ticks(plot)

remove_y_axis_labels(plot)

remove_y_axis_title(plot)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}
}
\value{
A \code{tidyplot} object.
}
\description{
Remove y-axis or parts of it
}
\examples{
# Before removing
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_mean_bar()

# After removing
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_mean_bar() \%>\%
  remove_y_axis_line()

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_mean_bar() \%>\%
  remove_y_axis_ticks()

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_mean_bar() \%>\%
  remove_y_axis_labels()

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_mean_bar() \%>\%
  remove_y_axis_title()

study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_mean_bar() \%>\%
  remove_y_axis()

}
