% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_as_plink.R
\name{gt_as_plink}
\alias{gt_as_plink}
\title{Export a \code{gen_tibble} object to PLINK bed format}
\usage{
gt_as_plink(
  x,
  file = NULL,
  type = c("bed", "ped", "raw"),
  overwrite = TRUE,
  chromosomes_as_int = FALSE
)
}
\arguments{
\item{x}{a \code{\link{gen_tibble}} object}

\item{file}{a character string giving the path to output file. If left to
NULL, the output file will have the same path and prefix of the
backingfile.}

\item{type}{one of "bed", "ped" or "raw"}

\item{overwrite}{boolean whether to overwrite the file.}

\item{chromosomes_as_int}{boolean whether to use the integer representation
of the chromosomes}
}
\value{
the path of the saved file
}
\description{
This function exports all the information of a \code{gen_tibble} object into a
PLINK bed, ped or raw file (and associated files, i.e. .bim and .fam for
.bed; .fam for .ped).
}
\details{
If the gen_tibble has been read in from vcf format, family.ID in the
resulting plink files will be the same as sample.ID. If the gen_tibble has a
grouping variable, this will be used as the family.ID in the resulting plink
files. NOTE that writing to bed has been optimised for speed, but writing to
ped or raw is slower, especially for large datasets.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Write a bed file
example_gt \%>\% gt_as_plink(type = "bed", file = paste0(tempfile(), "_plink"))

# Write a ped file
example_gt \%>\% gt_as_plink(type = "ped", file = paste0(tempfile(), "_plink"))

# Write a raw file
example_gt \%>\% gt_as_plink(type = "raw", file = paste0(tempfile(), "_plink"))
}
