% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{solvemass_chem}
\alias{solvemass_chem}
\title{Convert mg/L of chemical to lb/day}
\usage{
solvemass_chem(dose, flow, strength = 100)
}
\arguments{
\item{dose}{Chemical dose in mg/L as chemical}

\item{flow}{Plant flow in MGD}

\item{strength}{Chemical product strength in percent. Defaults to 100 percent.}
}
\value{
A numeric value for the chemical mass in lb/day.
}
\description{
This function takes a chemical dose in mg/L, plant flow, and chemical strength and calculates lb/day of product
}
\examples{
alum_mass <- solvemass_chem(dose = 20, flow = 10, strength = 49)

}
