% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water.R
\name{linear_water}
\alias{linear_water}
\title{Download an linear water shapefile into R}
\usage{
linear_water(state, county, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code of the state of the county you'd like to
download the water features for. Can also be state name or abbreviation
(case-insensitive).}

\item{county}{The three-digit FIPS code of the county you'd like the water
features for.  Can also be a county name.}

\item{year}{the data year; defaults to 2022}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
From the US Census Bureau: "The linear hydrography shapefile contains all linear
features with "H" (Hydrography) type MTFCCs in the
MAF/TIGER database by county. The shapefiles are provided at a county geographic extent and in linear
elemental feature geometry. The linear hydrography shapefile includes streams/rivers, braided streams,
canals, ditches, artificial paths, and aqueducts. A linear hydrography feature may include edges with both
perennial and intermittent persistence."
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\examples{
\dontrun{
library(tigris)

dallas_water <- linear_water("TX", "Dallas")

plot(dallas_water$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc.pdf}

Other water functions: 
\code{\link{area_water}()},
\code{\link{coastline}()}
}
\concept{water functions}
