% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.R
\name{plot_map}
\alias{plot_map}
\title{Mapa interativo de pontos de coleta}
\usage{
plot_map(
  data,
  popup_cols = NULL,
  cluster = TRUE,
  color_by = NULL,
  tiles = "OpenStreetMap"
)
}
\arguments{
\item{data}{Um data.frame contendo as colunas de coordenadas.
Sao aceitos nomes "latitude"/"longitude" ou "lat"/"lon".}

\item{popup_cols}{Vetor de colunas a exibir no popup (ex.: c("rio","ponto","data","iqa")).
Se NULL, usa colunas comuns se existirem.}

\item{cluster}{Agrupar marcadores proximos (TRUE/FALSE). Default = TRUE.}

\item{color_by}{Nome de coluna para colorir os pontos (opcional).
Se for "iqa", aplica classes de qualidade da agua.}

\item{tiles}{Provedor de tiles (default = "OpenStreetMap").}
}
\value{
Objeto htmlwidget (mapa Leaflet).
}
\description{
Gera um mapa Leaflet com os pontos de coleta que possuam coordenadas
de latitude e longitude validas. Mostra informacoes adicionais no popup.
}
\examples{
df <- data.frame(
  rio = c("Buranhem","Chamagunga"),
  ponto = c("P1","P2"),
  data = as.Date(c("2025-09-20","2025-09-21")),
  latitude = c(-16.435, -16.498),
  longitude = c(-39.062, -39.080),
  iqa = c(72, 58)
)
plot_map(df, popup_cols = c("rio","ponto","data","iqa"), color_by = "iqa")

}
