% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asis-nodes.R
\name{protect_inline_math}
\alias{protect_inline_math}
\title{Find and protect all inline math elements}
\usage{
protect_inline_math(body, ns)
}
\arguments{
\item{body}{an XML document}

\item{ns}{an XML namespace}
}
\value{
a modified \emph{copy} of the original XML document
}
\description{
Find and protect all inline math elements
}
\examples{
txt <- commonmark::markdown_xml(
  "This sentence contains $I_A$ $\\\\frac{\\\\pi}{2}$ inline $\\\\LaTeX$ math."
)
txt <- xml2::read_xml(txt)
cat(tinkr::to_md(list(body = txt, yaml = "")), sep = "\n")
ns  <- tinkr::md_ns()
if (requireNamespace("withr")) {
protxt <- withr::with_namespace("tinkr", protect_inline_math(txt, ns))
cat(tinkr::to_md(list(body = protxt, yaml = "")), sep = "\n")
}
}
\keyword{internal}
