% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_tt.R
\name{save_tt}
\alias{save_tt}
\title{Save a Tiny Table to File}
\usage{
save_tt(x, output, overwrite = FALSE)
}
\arguments{
\item{x}{The tinytable object to be saved.}

\item{output}{String or file path.
\itemize{
\item If \code{output} is "markdown", "latex", "html", "html_portable", or "typst", the table is returned in a string as an \code{R} object.
\item If \code{output} is a valid file path, the table is saved to file. The supported extensions are: .docx, .html, .png, .pdf, .tex, .typ, and .md (with aliases .txt, .Rmd and .qmd).
\item If \code{output} is "html_portable" or the global option \code{tinytable_html_portable} is \code{TRUE},
the images are included in the HTML as base64 encoded string instead of link to a local file.
}}

\item{overwrite}{A logical value indicating whether to overwrite an existing file.}
}
\value{
A string with the table when \code{output} is a format, and the file path when \code{output} is a valid path.
}
\description{
This function saves an object of class tinytable to a specified file and format, with an option to overwrite existing files.
}
\examples{
library(tinytable)
x <- mtcars[1:4, 1:5]

fn <- file.path(tempdir(), "test.html")
tt(x) |> save_tt(fn, overwrite = TRUE)

library(tinytable)
filename <- file.path(tempdir(), "table.tex")
tt(mtcars[1:4, 1:4]) |> save_tt(filename)

}
