% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx_distances.R
\name{approx_distances}
\alias{approx_distances}
\title{Approximate distances}
\usage{
approx_distances(x, y = NULL, projection = NULL, target = NULL)
}
\arguments{
\item{x}{object that can be coerced to a bounding box with \code{\link{bb}}, or a pair of coordintes (vector of two). In the former case, the distance across the horizontal and vertical centerlines of the bounding box are approximated. In the latter case, \code{y} is also required; the distance between points \code{x} and \code{y} is approximated.}

\item{y}{a pair of coordintes, vector of two. Only required when \code{x} is also a pair of coordintes.}

\item{projection}{projection code, needed in case \code{x} is a bounding box or when \code{x} and \code{y} are pairs of coordinates. See \code{\link{get_proj4}}}

\item{target}{target unit, one of:  \code{"m"}, \code{"km"}, \code{"mi"}, and \code{"ft"}.}
}
\value{
If \code{y} is specifyed, a list of two: unit and dist. Else, a list of three: unit, hdist (horizontal distance) and vdist (vertical distance).
}
\description{
Approximate distances between two points or across the horizontal and vertical centerlines of a bounding box.
}
\examples{
\dontrun{
if (require(tmap)) {
    data(NLD_prov)

    # North-South and East-West distances of the Netherlands
    approx_distances(NLD_prov)

    # Distance between Maastricht and Groningen
    p_maastricht <- geocode_OSM("Maastricht")$coords
    p_groningen <- geocode_OSM("Groningen")$coords
    approx_distances(p_maastricht, p_groningen, projection = 4326, target = "km")

    # Check distances in several projections
    sapply(c(3035, 28992, 4326), function(projection) {
        p_maastricht <- geocode_OSM("Maastricht", projection = projection)$coords
        p_groningen <- geocode_OSM("Groningen", projection = projection)$coords
        approx_distances(p_maastricht, p_groningen, projection = projection)
    })
}
}
}
\seealso{
\code{\link{approx_areas}}
}
