% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_centralities}
\alias{plot.tna_centralities}
\title{Plot Centrality Measures}
\usage{
\method{plot}{tna_centralities}(
  x,
  reorder = TRUE,
  ncol = 3,
  scales = c("free_x", "fixed"),
  colors,
  labels = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{tna_centralities}.}

\item{reorder}{A \code{logical} value indicating whether to reorder the values
for each centrality in a descending order. The default is \code{TRUE}.}

\item{ncol}{Number of columns to use for the facets. The default is 3.}

\item{scales}{Either \code{"fixed"} or \code{"free_x"} (the default). If \code{"free_x"},
the horizontal axis is scaled individually in each facet. If \code{"fixed"},
the same values are used for all axes.}

\item{colors}{The colors for each node (default is the model colors
if the \code{tna} model object is passed, otherwise \code{"black"}).}

\item{labels}{A \code{logical} value indicating whether to show the centrality
numeric values. The default is \code{TRUE}.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object displaying the lollipop charts for each centrality
measure.
}
\description{
Plots the centrality measures of a \code{tna_centralities} object as a
lollipop chart. The resulting plot includes facets for each centrality
measure, showing the values for each state. The returned plot is a
\code{ggplot2} object, so it can be easily modified and styled. See
\code{\link[=centralities]{centralities()}} for details on the centrality measures.
}
\examples{
tna_model <- tna(engagement)
cm <- centralities(tna_model)
plot(cm, ncol = 4, reorder = TRUE)

}
\seealso{
Core functions
\code{\link{build_model}()},
\code{\link{centralities}()},
\code{\link{plot.tna}()},
\code{\link{plot_compare}()}
}
\concept{core}
