% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{increase_na_percentage}
\alias{increase_na_percentage}
\title{Increase Missing Values in a Matrix}
\usage{
increase_na_percentage(mat, target_na_percentage)
}
\arguments{
\item{mat}{Matrix to modify}

\item{target_na_percentage}{Numeric between 0 and 1 specifying desired proportion of NAs}
}
\value{
A \code{matrix} with an increased number of \code{NA} values, maintaining symmetry.
}
\description{
Strategically introduces NA values into a distance matrix while maintaining symmetry.
New NA values are added preferentially farther from the diagonal to simulate real-world
measurement patterns where distant pairs are more likely to be unmeasured.
}
\details{
The function:
\enumerate{
\item Calculates needed additional NAs to reach target percentage
\item Creates probability matrix favoring off-diagonal elements
\item Randomly selects positions weighted by distance from diagonal
\item Maintains matrix symmetry by mirroring NAs
}
}
\examples{
# Create sample distance matrix
dist_mat <- matrix(runif(100), 10, 10)
dist_mat[lower.tri(dist_mat)] <- t(dist_mat)[lower.tri(dist_mat)]
diag(dist_mat) <- 0

# Increase NAs to 70\%
sparse_mat <- increase_na_percentage(dist_mat, 0.7)
}
