% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{new_aesthetic_config}
\alias{new_aesthetic_config}
\title{Plot Aesthetic Configuration Class}
\usage{
new_aesthetic_config(
  point_size = 3.5,
  point_alpha = 0.8,
  point_shapes = c(antigen = 16, antiserum = 0),
  color_palette = c25,
  gradient_colors = list(low = "blue", high = "red"),
  show_labels = FALSE,
  show_title = FALSE,
  label_size = 3,
  title_size = 14,
  subtitle_size = 12,
  axis_title_size = 12,
  axis_text_size = 10,
  legend_text_size = 10,
  legend_title_size = 12,
  show_legend = TRUE,
  legend_position = "right",
  arrow_head_size = 0.2,
  arrow_alpha = 0.6
)
}
\arguments{
\item{point_size}{Base point size}

\item{point_alpha}{Point transparency}

\item{point_shapes}{Named vector of shapes for different point types}

\item{color_palette}{Color palette name or custom palette}

\item{gradient_colors}{List with low and high colors for gradients}

\item{show_labels}{Whether to show point labels}

\item{show_title}{Whether to show plot title (default: FALSE)}

\item{label_size}{Label text size}

\item{title_size}{Title text size}

\item{subtitle_size}{Subtitle text size}

\item{axis_title_size}{Axis title text size}

\item{axis_text_size}{Axis text size}

\item{legend_text_size}{Legend text size}

\item{legend_title_size}{Legend title text size}

\item{show_legend}{Whether to show the legend}

\item{legend_position}{Legend position ("none", "right", "left", "top", "bottom")}

\item{arrow_head_size}{Size of the arrow head for velocity arrows (in cm)}

\item{arrow_alpha}{Transparency of arrows (0 = invisible, 1 = fully opaque)}
}
\value{
An S3 object of class \code{aesthetic_config}, which is a list
containing the specified configuration parameters for plot aesthetics.
}
\description{
S3 class for configuring plot visual aesthetics including points, colors,
labels and text elements.
}
