% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_sig.r
\name{stat_sig}
\alias{stat_sig}
\title{Assign Significance Codes Based on P-Values}
\usage{
stat_sig(p_val_data)
}
\arguments{
\item{p_val_data}{A numeric vector representing the p-values to be categorized.
The vector should contain p-values between 0 and 1.}
}
\value{
A character vector with the assigned significance codes for each p-value.
}
\description{
This function assigns significance codes to a p-value vector based on commonly
accepted significance thresholds. The significance codes are:
\itemize{
\item \code{"***"} for p-values <= 0.001
\item \code{"**"} for p-values <= 0.01 and > 0.001
\item \code{"*"} for p-values <= 0.05 and > 0.01
\item \code{"."} for p-values <= 0.1 and > 0.05
\item \code{"<>"} for p-values > 0.1
}
}
\examples{
# Example usage of the stat_sig function
data <- data.frame(p_value = c(0.001, 0.03, 0.12, 0.05, 0.07))

data |>
  dplyr::mutate(significance = stat_sig(p_val_data = p_value))

}
\author{
Nicolas Foss, Ed.D., MS
}
