% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.1.0.R
\name{is.outlier}
\alias{is.outlier}
\title{Outlier Identification}
\usage{
is.outlier(x, method = c("iqr", "sigma", "zscore"), param = NULL)
}
\arguments{
\item{x}{a time series or any other R data type.}

\item{method}{method based on which the outliers are identified. Available options are `\code{iqr}`, `\code{sigma}`, and `\code{zscore}`.}

\item{param}{parameter value for setting specific boundary criteria. Default is \code{NULL}.}
}
\value{
A vector indicating whether the values in \code{x} are outliers (\code{TRUE}) or not (\code{FALSE}).
}
\description{
The function `\code{is.outlier}` checks whether any time series observations are outliers based on the interquartile range (IQR) rule.
}
\details{
With \code{method = "iqr"}, the interquartile range rule for outlier identification is applied. An observation \eqn{x_i} will be identified as outlier if one of the following conditions fulfils:

\deqn{x_i < q_1 - m \cdot (q_3 - q_1)}

\deqn{x_i > q_3 + m \cdot (q_3 - q_1)}

where \eqn{q_1} and \eqn{q_3} are the 1st and 3rd quartiles of the time series \code{x}, respectively. \code{m} is the value specified by \code{param}. If omitted, it will be set as 1.5.

By using \code{method = "sigma"}, the following criteria for outlier identification, known as the 3-sigma rule, are applied:

\deqn{x_i < \mu(x) - m \cdot \sigma(x)}

\deqn{x_i > \mu(x) + m \cdot \sigma(x)}

where \eqn{\mu(x)} and \eqn{\sigma(x)} are the mean and standard deviation of the time series \code{x}, respectively. \code{m} is the value specified by \code{param}. If omitted, it will be set as 3.

The z-score rule, specified by \code{method = "zscore"}, compares the standardised observation values to a specific threshold:

\deqn{\left|\dfrac{(x_i - \mu(x))}{\sigma(x)}\right| > m}

where \eqn{\mu(x)} and \eqn{\sigma(x)} are the mean and standard deviation of the time series \code{x}, respectively. \code{m} is the value specified by \code{param}. If omitted, it will be set as 2. Note that 2 is the threshold for mild outliers. If checking for extreme outliers is required, the value should be set as 3.
}
\examples{
is.outlier(airport$Travellers, method = "zscore")
}
\author{
Ka Yui Karl Wu
}
