% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_outlier.R
\name{sim_outlier}
\alias{sim_outlier}
\title{Simulate an outlier}
\usage{
sim_outlier(
  n,
  k,
  freq = 12,
  type = c("AO", "LS", "TC"),
  effect_size = 10,
  start = c(2020, 1),
  multiplicative = TRUE
)
}
\arguments{
\item{n}{Time series length}

\item{k}{Number of outliers}

\item{freq}{Frequency of the time series}

\item{type}{Type of outlier}

\item{effect_size}{Mean size of outlier}

\item{start}{Start date of output time series}

\item{multiplicative}{Boolean. Is multiplicative time series model assumed?}
}
\value{
The function returns k time series of class \code{xts} containing the k outlier effects
}
\description{
Simulate an outlier
}
\details{
Three types of outliers are implemented: AO=Additive outlier, LS=Level shift, TC=Temporary Change. The effect size is stochastic as it is drawn from a normal distribution with mean equal to the specified effect_size and a standard deviation of 1/4*effect_size. This is multiplied randomly with -1 or 1 to get negative shocks as well.
If multiplicative is true, the effect size is measured in percentage. If is not true, the effect size is unit less and thus adopts the unit of the time series the outliers are added to.
}
\examples{
plot(sim_outlier(60, 4, type=c("AO", "LS")))
}
\references{
Ollech, D. (2021). Seasonal adjustment of daily time series. Journal of Time Series Econometrics. \doi{10.1515/jtse-2020-0028}
}
\author{
Daniel Ollech
}
