% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sbv.R
\name{read_sbv}
\alias{read_sbv}
\title{Read SBV file}
\usage{
read_sbv(file)
}
\arguments{
\item{file}{The file name of the \code{sbv} file}
}
\value{
A \code{data.frame} with start/stop times and the text
}
\description{
Read SBV file
}
\examples{
if (yt_authorized()){
vids <- list_my_videos()
res <- list_caption_tracks(video_id = vids$contentDetails.videoId[1])
cap <- get_captions(id = res$id, as_raw = FALSE)
tfile <- tempfile(fileext = ".sbv")
writeLines(cap, tfile)
x <- read_sbv(tfile)
if (requireNamespace("hms", quietly = TRUE)) {
  x$start <- hms::as_hms(x$start)
  x$stop <- hms::as_hms(x$stop)
}
}
}
