% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxDoCbyPath.R
\name{umxTwinMaker}
\alias{umxTwinMaker}
\title{Make a twin model from the model describing just one person}
\usage{
umxTwinMaker(
  name = "m1",
  paths,
  t1_t2links = list(a = c(1, 0.5), c = c(1, 1), e = c(0, 0)),
  mzData = NULL,
  dzData = NULL,
  sep = "_T",
  autoRun = getOption("umx_auto_run")
)
}
\arguments{
\item{name}{The name for the resulting \code{\link[=umxSuperModel]{umxSuperModel()}} (Default "m1").}

\item{paths}{A vector of \code{\link[=umxPath]{umxPath()}}s describing one person.}

\item{t1_t2links}{base name (and values) of paths that covary between T1 and T2. Default: c('a'=c(1,.5), 'c'=c(1,1), 'e'=c(0,0))}

\item{mzData}{Data for MZ twins.}

\item{dzData}{Data for DZ twins.}

\item{sep}{The separator used to create twin 1 and 2 names (Default "_T")}

\item{autoRun}{Whether to run the supermodel before returning it.}
}
\value{
\itemize{
\item \code{\link[=umxSuperModel]{umxSuperModel()}}
}
}
\description{
\code{xmu_path2twin} takes a collection of paths describing the model for 1 person
and returns a completed twin model. This consists of a \code{\link[=umxSuperModel]{umxSuperModel()}} containing
\code{MZ} and \code{DZ} \code{\link[=umxRAM]{umxRAM()}} models.

Pass into \code{umxTwinMaker}:
\enumerate{
\item A list of \code{paths} making up the twin 1 model
\item In \code{t1_t2links}, a vector describing the component relationships connecting twin 1 to twin 2
(The default here is 1 and .5 for the a, and, for c and e are 1 and 0 in both groups, respectively.
}

\emph{Details}

Some rules. All labels are expanded with a twin suffix: so "var1" -> "var1_T1" etc. so you
provide the person-model using just the base name (and tell \code{\link[=umxTwinMaker]{umxTwinMaker()}} how to expand it by providing a separator string).

Rule 2: The latent a, c, and e latent variables must be labelled to match the base name given in t1_t2links.
To avoid clashes, variables must not match the numbered variables in \code{t1_t2links}  - by default names like "a1" are reserved for ace.
}
\examples{
\dontrun{
# We'll make some ACE models, but first, let's clean up the twinData 
# set for analysis
# 1. Add a separator to the twin variable names (with sep = "_T")
# 2. Scale the data so it's easier for the optimizer.
data(twinData)
tmp = umx_make_twin_data_nice(data=twinData, sep="", zygosity="zygosity", numbering=1:2)
tmp = umx_scale_wide_twin_data(varsToScale= c("wt", "ht"), sep= "_T", data= tmp)
mzData = subset(tmp, zygosity \%in\%  c("MZFF", "MZMM"))
dzData = subset(tmp, zygosity \%in\%  c("DZFF", "DZMM"))

# ==========================
# = Make an ACE twin model =
# ==========================
# 1. Define paths for *one* person:
paths = c(
   umxPath(v1m0 = c("a1", 'c1', "e1")),
   umxPath(means = c("wt")),
   umxPath(c("a1", 'c1', "e1"), to = "wt", values=.2)
)
# 2. Make a twin model from the paths for one person
m1 = umxTwinMaker("test", paths, mzData = mzData, dzData= dzData)
plot(m1, std= TRUE, means= FALSE)

# 3. comparison with umxACE...
m2 = umxACE(selDVs="wt", mzData = mzData, dzData=dzData, sep="_T")

# =====================
# = Bivariate example =
# =====================
latents = paste0(rep(c("a", "c", "e"), each = 2), 1:2)
biv = c(
umxPath(v1m0 = latents),
umxPath(mean = c("wt", "ht")),
umxPath(fromEach = c("a1", 'c1', "e1"), to = c("ht", "wt")),
umxPath(c("a2", 'c2', "e2"), to = "wt")
)
tmp= umxTwinMaker(paths= biv, mzData = mzData, dzData= dzData)
plot(tmp, means=FALSE)

# How to use latents other than a, c, and e: define in t1_t2links
paths = c(
umxPath(v1m0 = c("as1", 'c1', "e1")),
umxPath(means = c("wt")),
umxPath(c("as1", 'c1', "e1"), to = "wt", values=.2)
)
m1 = umxTwinMaker("test", paths, mzData = mzData, dzData= dzData, 
	t1_t2links = list('as'=c(1, .5), 'c'=c(1, 1), 'e'=c(0, 0))
)

}

}
\references{
\itemize{
\item \href{https://tbates.github.io}{tutorials}, \href{https://github.com/tbates/umx}{github}
}
}
\seealso{
\itemize{
\item \code{\link[=umxRAM]{umxRAM()}}, \code{\link[=umxSuperModel]{umxSuperModel()}}, \code{\link[=umxPath]{umxPath()}}
}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umx}},
\code{\link{umxACE}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxCP}()},
\code{\link{umxDiffMZ}()},
\code{\link{umxDiscTwin}()},
\code{\link{umxDoC}()},
\code{\link{umxDoCp}()},
\code{\link{umxGxE}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxIP}()},
\code{\link{umxMRDoC}()},
\code{\link{umxReduce}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()}
}
\concept{Twin Modeling Functions}
