% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aarhus.R
\docType{data}
\name{aarhus}
\alias{aarhus}
\title{The colours of Aarhus University, Denmark}
\format{
An object of class \code{character} of length 20.
}
\source{
Color definitions are based on 
\href{https://www.au.dk}{AU}'s 
\href{https://medarbejdere.au.dk/en/administration/communication/guidelines/guidelinesforcolours}{design guidelines} (HTML).
}
\usage{
aarhus
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{aarhus} provides the colours   
of \href{https://www.au.dk}{Aarhus University}, Denmark.
}
\details{
Aarhus University's primary identity colour is 
\code{AU blue}, defined as Pantone 287 EC, CMYK 100 80 0 15, RGB 0 61 115, or HEX "#003d73".

There are also a number of bright secondary colours 
which ensure greater variation in the daily work with the design line.

The creative scope is further widened by the possibility of mixing 
\code{AU blue} and the secondary colours with 75\% black for darker, 
more discreet and classic colour tints.

\code{aarhus} uses the HEX color definitions.
}
\examples{
aarhus
unikn::seecol(aarhus, main = "The colours of Aarhus University, Denmark")  # view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Danish university color palettes: 
\code{\link{ku_1}},
\code{\link{ku_2}}
}
\author{
\strong{unicol}, 2023-10-14.
}
\concept{Danish university color palettes}
\keyword{datasets}
