test_that("check utilities", {
  expect_error(validateSummarisedResult(1))
})
test_that("helper table functions", {
  expect_equal(names(tableOptions()), c(
    'decimals', 'decimalMark', 'bigMark', 'keepNotFormatted', 'useFormatOrder',
    'delim', 'includeHeaderName', 'includeHeaderKey', 'na', 'title',
    'subtitle', 'caption', 'groupAsColumn', 'groupOrder', 'merge'
  ))
  expect_equal(
    tableStyleCode(type = "gt"),
    list(
      "header" = list(gt::cell_fill(color = "#c8c8c8"),
                      gt::cell_text(weight = "bold", align = "center")),
      "header_name" = list(gt::cell_fill(color = "#d9d9d9"),
                           gt::cell_text(weight = "bold", align = "center")),
      "header_level" = list(gt::cell_fill(color = "#e1e1e1"),
                            gt::cell_text(weight = "bold", align = "center")),
      "column_name" = list(gt::cell_text(weight = "bold", align = "center")),
      "group_label" = list(gt::cell_fill(color = "#e9e9e9"),
                           gt::cell_text(weight = "bold")),
      "title" = list(gt::cell_text(weight = "bold", size = 15, align = "center")),
      "subtitle" = list(gt::cell_text(weight = "bold", size = 12, align = "center")),
      "body" = list()
    ) |>
      rlang::expr()
  )
  expect_equal(
    tableStyleCode(type = "flextable"),
    list(
      "header" = list(
        "cell" = officer::fp_cell(background.color = "#c8c8c8"),
        "text" = officer::fp_text(bold = TRUE)
      ),
      "header_name" = list(
        "cell" = officer::fp_cell(background.color = "#d9d9d9"),
        "text" = officer::fp_text(bold = TRUE)
      ),
      "header_level" = list(
        "cell" = officer::fp_cell(background.color = "#e1e1e1"),
        "text" = officer::fp_text(bold = TRUE)
      ),
      "column_name" = list(
        "text" = officer::fp_text(bold = TRUE),
        "cell" = officer::fp_cell( border = officer::fp_border(color = "gray"))
      ),
      "group_label" = list(
        "cell" = officer::fp_cell(
          background.color = "#e9e9e9",
          border = officer::fp_border(color = "gray")
        ),
        "text" = officer::fp_text(bold = TRUE)
      ),
      "title" = list(
        "text" = officer::fp_text(bold = TRUE, font.size = 15),
        "paragraph" = officer::fp_par(text.align = "center"),
        "cell" = officer::fp_cell( border = officer::fp_border(color = "gray"))
      ),
      "subtitle" = list(
        "text" = officer::fp_text(bold = TRUE, font.size = 12),
        "paragraph" = officer::fp_par(text.align = "center"),
        "cell" = officer::fp_cell( border = officer::fp_border(color = "gray"))
      ),
      "body" = list(
        "cell" = officer::fp_cell(
          background.color = "transparent",
          border = officer::fp_border(color = "gray")
        )
      )
    ) |>
      rlang::expr()
  )

  expect_equal(
    tableStyleCode(type = "datatable"),
    list(caption = "caption-side: bottom; text-align: center;", scrollX = TRUE,
         scrollY = 400, scroller = TRUE, deferRender = TRUE, scrollCollapse = TRUE,
         fixedColumns = list(leftColumns = 0, rightColumns = 0), fixedHeader = TRUE,
         pageLength = 10, lengthMenu = c(5, 10, 20, 50, 100), filter = "bottom",
         searchHighlight = TRUE, rownames = FALSE) |>
      rlang::expr()
  )

  expect_equal(
    tableStyleCode(type = "reactable"),
    list(defaultColDef = reactable::colDef(sortable = TRUE, resizable = TRUE,
                                           filterable = TRUE, headerStyle = list(textAlign = "center")),
         defaultColGroup = reactable::colGroup(headerStyle = list(textAlign = "center")),
         defaultSortOrder = "asc", defaultSorted = NULL, defaultPageSize = 10,
         defaultExpanded = TRUE, highlight = TRUE, outlined = FALSE,
         bordered = FALSE, borderless = FALSE, striped = TRUE, theme = NULL) |>
      rlang::expr()
  )

  expect_equal(
    tableStyleCode(type = "gt", style = "darwin"),
    list(
      "header" = list(
        gt::cell_fill(color = "#003399"),
        gt::cell_text(weight = "bold", color = "white", align = "center", font = "Calibri", size = 11)
      ),
      "header_name" = list(
        gt::cell_fill(color = "#003399"),
        gt::cell_text(weight = "bold", color = "white", align = "center", font = "Calibri", size = 11)
      ),
      "header_level" = list(
        gt::cell_fill(color = "#003399"),
        gt::cell_text(color = "white", weight = "bold", align = "center", font = "Calibri", size = 11)
      ),
      "column_name" = list(
        gt::cell_fill(color = "#003399"),
        gt::cell_text(weight = "bold", color = "white", align = "center", font = "Calibri", size = 11)
      ),
      "group_label" = list(
        gt::cell_fill(color = "#003399"),
        gt::cell_borders(color = "#003399"),
        gt::cell_text(weight = "bold", color = "white", font = "Calibri", size = 9)
      ),
      "title" = list(gt::cell_text(weight = "bold", font = "Calibri", size = 15, align = "center")),
      "subtitle" = list(
        gt::cell_text(weight = "bold", size = 12, font = "Calibri", align = "center")
      ),
      body = list(
        gt::cell_borders(color = "#003399", weight = 0.5),
        gt::cell_text(font = "calibri", size = 9)
      )
    ) |>
      rlang::expr()
  )

  expect_equal(
    tableStyleCode(type = "flextable", style = "darwin"),
    list(
      "header" = list(
        "cell" = officer::fp_cell(
          background.color = "#003399",
          border = officer::fp_border(color = "#003399")
        ),
        "text" = officer::fp_text(bold = TRUE, color = "white", font.size = 11)
      ),
      "header_name" = list(
        "cell" = officer::fp_cell(
          background.color = "#003399",
          border = officer::fp_border(color = "#003399")
        ),
        "text" = officer::fp_text(bold = TRUE, color = "white", font.size = 11, font.family = "calibri")
      ),
      "header_level" = list(
        "cell" = officer::fp_cell(
          background.color = "#003399",
          border = officer::fp_border(color = "#003399"),
        ),
        "text" = officer::fp_text(bold = TRUE, color = "white", font.size = 11, font.family = "calibri")
      ),
      "column_name" = list(
        "cell" = officer::fp_cell(
          background.color = "#003399",
          border = officer::fp_border(color = "#003399"),
        ),
        "text" = officer::fp_text(bold = TRUE, color = "white", font.size = 11, font.family = "calibri")
      ),
      "group_label" = list(
        "cell" = officer::fp_cell(
          background.color = "#003399",
          border = officer::fp_border(color = "#003399", width = 0.5)
        ),
        "text" = officer::fp_text(bold = TRUE, color = "white", font.size = 9, font.family = "calibri")
      ),
      "title" = list(
        "text" = officer::fp_text(bold = TRUE, font.size = 15, font.family = "calibri"),
        "paragraph" = officer::fp_par(text.align = "center")
      ),
      "subtitle" = list(
        "text" = officer::fp_text(bold = TRUE, font.size = 12, font.family = "calibri"),
        "paragraph" = officer::fp_par(text.align = "center")
      ),
      "body" = list(
        "cell" = officer::fp_cell(border = officer::fp_border(color = "#003399", width = 0.5)),
        "text" = officer::fp_text(font.size = 9, font.family = "calibri")
      )
    ) |>
      rlang::expr()
  )

  expect_error(tableStyleCode(type = "datatable", style = "darwin"))
  expect_error(tableStyleCode(type = "reactable", style = "darwin"))

  expect_true(all(c("tibble", "flextable", "gt") %in% tableType()))
})
