% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_counts}
\alias{effect_counts}
\title{Output effect sizes and test statistics for count data}
\usage{
effect_counts(data, cols, cross = NULL, metric = FALSE, clean = TRUE, ...)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{cross}{Optional, a grouping column. The column name without quotes.}

\item{metric}{When crossing variables, the cross column parameter can contain categorical or metric values.
By default, the cross column selection is treated as categorical data.
Set metric to TRUE, to treat it as metric and calculate correlations.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Other parameters passed to the appropriate effect function.}
}
\value{
A volker tibble.
}
\description{
The type of effect size depends on the number of selected columns:
\itemize{
\item One categorical column: see \link{effect_counts_one}
\item Multiple categorical columns: see \link{effect_counts_items}
}

Cross tabulations:
\itemize{
\item One categorical column and one grouping column: see \link{effect_counts_one_grouped}
\item Multiple categorical columns and one grouping column: see \link{effect_counts_items_grouped} (not yet implemented)
\item Multiple categorical columns and multiple grouping columns: \link{effect_counts_items_grouped_items} (not yet implemented)
}

By default, if you provide two column selections, the second column is treated as categorical.
Setting the metric-parameter to TRUE will call the appropriate functions for correlation analysis:
\itemize{
\item One categorical column and one metric column: see \link{effect_counts_one_cor} (not yet implemented)
\item Multiple categorical columns and one metric column: see \link{effect_counts_items_cor} (not yet implemented)
\item Multiple categorical columns and multiple metric columns:\link{effect_counts_items_cor_items} (not yet implemented)
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

effect_counts(data, sd_gender, adopter)

}
