% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{Jenkins}
\alias{Jenkins}
\title{Jenkins, Cowell and Flachaire}
\usage{
Jenkins(X, W = rep(1, length(X)), alfa = 0.8)
}
\arguments{
\item{X}{is a data vector}

\item{W}{is a vector of weights}

\item{alfa}{is the Jenkins coefficient parameter}
}
\value{
The value of Jenkins, Cowell and Flachaire coefficient.
}
\description{
Computes Jenkins as well as Cowell and Flachaire inequality measure of a given variable taking into account weights.
}
\details{
Jenkins coefficient is given by:
\deqn{J=1-\sum_{j=0}^{K-1} (p_{j+1}-p_{j})(GL_{j}+GL_{j+1})}

where GL is Generalized Lorenz curve.

Cowell and Flachaire coefficient with alpha parameter is given by:
\deqn{I(\alpha)=\frac{1}{\alpha(\alpha-1)}(\frac{1}{N}\sum_{i=1}^{N}s_{i}^{\alpha}-1)}

for \eqn{\alpha \in (0,1)}, and
\deqn{I(0)=-\frac{1}{N}\sum_{i=1}^{N} log(s_{i})}

for \eqn{\alpha = 0}.
}
\examples{
# Compare weighted and unweighted result
X=1:10
W=1:10
Jenkins(X)
Jenkins(X,W)

data(Tourism)
#Jenkins, Cowell and Flachaire coefficients for Total expenditure with sample weights
X=Tourism$`Total expenditure`
W=Tourism$`Sample weight`
Jenkins(X,W)


}
\references{
Jenkins S. P. and P. J. Lambert: (1997) Three ‘I’s of Poverty Curves, with an Analysis of U.K. Poverty Trends

Cowell F. A.: (2000) Measurement of Inequality, Handbook of Income Distribution

Cowell F. A., Flachaire E.: (2017) Inequality with Ordinal Data
}
