% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdi_search.R
\name{wdi_search}
\alias{wdi_search}
\title{Search for Keywords in Data Frame Columns}
\usage{
wdi_search(data, keywords, columns = NULL)
}
\arguments{
\item{data}{A data frame to search. It can include nested columns (lists
within columns).}

\item{keywords}{A character vector of keywords to search for within the
specified columns. The search is case-insensitive.}

\item{columns}{Optional. A character vector of column names to limit the
search to specific columns. If \code{NULL}, all columns in \code{data} will be
searched.}
}
\value{
A data frame containing only the rows where at least one keyword is
found in the specified columns. The returned data frame has the same
structure as \code{data}.
}
\description{
This function searches for specified keywords across columns in a data frame
and returns only the rows where at least one keyword appears in any of the
specified columns. It supports nested columns (lists within columns) and
provides the option to limit the search to specific columns.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Download indicators
indicators <- wdi_get_indicators()

# Search for keywords "inequality" or "gender" across all columns
wdi_search(
  indicators,
  keywords = c("inequality", "gender")
)

# Search for keywords only within the "indicator_name" column
wdi_search(
  indicators,
  keywords = c("inequality", "gender"),
  columns = c("indicator_name")
)
}
\dontshow{\}) # examplesIf}
}
