% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_patched_point_apsim.R
\encoding{UTF-8}
\name{get_patched_point_apsim}
\alias{get_patched_point_apsim}
\title{Get PatchedPoint Weather Data in the APSIM Format From SILO}
\usage{
get_patched_point_apsim(
  station_code,
  start_date,
  end_date = Sys.Date(),
  api_key = get_key(service = "SILO")
)
}
\arguments{
\item{station_code}{A \code{character} string or \code{factor} from
\code{\link[=get_stations_metadata]{get_stations_metadata()}} of the \acronym{BOM} station code for the station
of interest.}

\item{start_date}{A \code{character} string or \code{Date} object representing the
beginning of the range to query in the format \dQuote{yyyy-mm-dd}
(ISO8601).  Data returned is inclusive of this date.}

\item{end_date}{A \code{character} string or \code{Date} object representing the end of
the range query in the format  \dQuote{yyyy-mm-dd} (ISO8601).  Data
returned is inclusive of this date.  Defaults to the current system date.}

\item{api_key}{A \code{character} string containing your \acronym{API} key,
an e-mail address, for the request.  Defaults to automatically detecting
your key from your local .Renviron, .Rprofile or similar.  Alternatively,
you may directly provide your key as a string here.  If nothing is
provided, you will be prompted on how to set up your \R session so that it
is auto-detected.}
}
\value{
An \CRANpkg{apsimx} object of class \sQuote{met} with attributes.
}
\description{
Fetch \acronym{APSIM} .met file formatted weather data from the
\acronym{SILO} \acronym{API} derived from the \acronym{BOM} station
observations (PatchedPoint) data.
}
\details{
The \acronym{SILO} documentation provides the following information
for the PatchedPoint data.

\emph{These data are a continuous daily time series of data at either recording
stations or grid points across Australia:}
\itemize{
\item \emph{Data at station locations consists of observational records which have
been supplemented by interpolated estimates when observed data are missing.
Datasets are available at approximately 8,000 Bureau of Meteorology
recording stations around Australia.}
\item \emph{Data at grid points consists entirely of interpolated estimates. The
data are taken from the SILO gridded datasets and are available at any
pixel on a 0.05° × 0.05° grid over the land area of Australia (including
some islands).}
}
}
\section{Included Values}{


\describe{
\item{rain (mm)}{Rainfall}
\item{maxt (degrees C)}{Maximum temperature}
\item{mint (degrees C)}{Minimum temperature}
\item{vp (hPa)}{Vapour pressure}
\item{evap_pan (mm)}{Class A pan evaporation}
\item{radiation (Mj/\ifelse{html}{\out{m<sup>1</sup>}}{m\eqn{^1}})}{Solar
exposure, consisting of both direct and diffuse components}
}
}

\section{Value information}{


Solar radiation: total incoming downward shortwave radiation on a horizontal
surface, derived from estimates of cloud oktas and sunshine
\ifelse{html}{\out{duration<sup>2</sup>}}{duration\eqn{^2}}.

Evaporation and evapotranspiration: an overview of the variables provided by
\acronym{SILO} is available here,
\url{https://data.longpaddock.qld.gov.au/static/publications/Evapotranspiration_overview.pdf}.
}

\section{Data codes}{

Where the source code is a 6 digit string comprising the source code for the
6 variables. The single digit code for each variable is:

\describe{
\item{0}{an actual observation;}
\item{1}{an actual observation from a composite station;}
\item{2}{a value interpolated from daily observations;}
\item{3}{a value interpolated from daily observations using the anomaly
interpolation method for \acronym{CLIMARC} data;}
\item{6}{a synthetic pan value; or}
\item{7}{an interpolated long term average.}
}
}

\section{Saving objects}{

To save \dQuote{met} objects the \code{\link[apsimx:write_apsim_met]{apsimx::write_apsim_met()}} is reexported.
Note that when saving, comments from SILO will be included, but these will
not be printed as a part of the resulting \code{met} object in your \R session.
}

\examples{
\dontrun{
# requires an API key as your email address
# Source observation data for Wongan Hills station, WA (008137)
wd <- get_patched_point_apsim(
  station_code = "008137",
  start_date = "20220101",
  end_date = "20221231",
  api_key = "your_api_key"
)
}
}
\references{
\enumerate{
\item Rayner, D. (2005). Australian synthetic daily Class A pan evaporation.
Technical Report December 2005, Queensland Department of Natural Resources
and Mines, Indooroopilly, Qld., Australia, 40 pp.
\item Morton, F. I. (1983). Operational estimates of areal evapotranspiration
and their significance to the science and practice of hydrology, \emph{Journal
of Hydrology}, Volume 66, 1-76.
}
}
\seealso{
Other SILO: 
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_data_drill}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_patched_point}()},
\code{\link{get_stations_metadata}()},
\code{\link{silo_daily_values}}

Other APSIM: 
\code{\link{get_data_drill_apsim}()},
\code{\link{get_dpird_apsim}()},
\code{\link{reexports}}

Other data fetching: 
\code{\link{get_ag_bulletin}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_data_drill}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_patched_point}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()}
}
\author{
Rodrigo Pires, \email{rodrigo.pires@dpird.wa.gov.au}, and Adam
Sparks, \email{adamhsparks@gmail.com}
}
\concept{APSIM}
\concept{SILO}
\concept{data fetching}
