% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{predict.word2vec}
\alias{predict.word2vec}
\title{Predict functionalities for a word2vec model}
\usage{
\method{predict}{word2vec}(
  object,
  newdata,
  type = c("nearest", "embedding"),
  top_n = 10L,
  encoding = "UTF-8",
  ...
)
}
\arguments{
\item{object}{a word2vec model as returned by \code{\link{word2vec}} or \code{\link{read.word2vec}}}

\item{newdata}{for type 'embedding', \code{newdata} should be a character vector of words\cr
for type 'nearest', \code{newdata} should be a character vector of words or a matrix in the embedding space}

\item{type}{either 'embedding' or 'nearest'. Defaults to 'nearest'.}

\item{top_n}{show only the top n nearest neighbours. Defaults to 10.}

\item{encoding}{set the encoding of the text elements to the specified encoding. Defaults to 'UTF-8'.}

\item{...}{not used}
}
\value{
depending on the type, you get a different result back:
\itemize{
\item{for type nearest: a list of data.frames with columns term, similarity and rank indicating with words which are closest to the provided \code{newdata} words or word vectors. If \code{newdata} is just one vector instead of a matrix, it returns a data.frame}
\item{for type embedding: a matrix of word vectors of the words provided in \code{newdata}}
}
}
\description{
Get either 
\itemize{
\item{the embedding of words}
\item{the nearest words which are similar to either a word or a word vector}
}
}
\examples{
path  <- system.file(package = "word2vec", "models", "example.bin")
model <- read.word2vec(path)
emb <- predict(model, c("bus", "toilet", "unknownword"), type = "embedding")
emb
nn  <- predict(model, c("bus", "toilet"), type = "nearest", top_n = 5)
nn

# Do some calculations with the vectors and find similar terms to these
emb <- as.matrix(model)
vector <- emb["buurt", ] - emb["rustige", ] + emb["restaurants", ]
predict(model, vector, type = "nearest", top_n = 10)

vector <- emb["gastvrouw", ] - emb["gastvrij", ]
predict(model, vector, type = "nearest", top_n = 5)

vectors <- emb[c("gastheer", "gastvrouw"), ]
vectors <- rbind(vectors, avg = colMeans(vectors))
predict(model, vectors, type = "nearest", top_n = 10)
}
\seealso{
\code{\link{word2vec}}, \code{\link{read.word2vec}}
}
