% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_mixmeta.R
\name{anlz_mixmeta}
\alias{anlz_mixmeta}
\title{Fit a mixed meta-analysis regression model of trends}
\usage{
anlz_mixmeta(metseason, yrstr = 2000, yrend = 2019)
}
\arguments{
\item{metseason}{output from \code{\link{anlz_metseason}}}

\item{yrstr}{numeric for starting year}

\item{yrend}{numeric for ending year}
}
\value{
A list of \code{\link[mixmeta]{mixmeta}} fitted model objects
}
\description{
Fit a mixed meta-analysis regression model of trends
}
\details{
Parameters are not back-transformed if the original GAM used a transformation of the response variable
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
metseason <- anlz_metseason(mod, doystr = 90, doyend = 180)
anlz_mixmeta(metseason, yrstr = 2016, yrend = 2019)
}
\concept{analyze}
