% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderTest2grp.R
\name{moderTest2grp}
\alias{moderTest2grp}
\title{Moderated Pair-Wise t-test From Limma}
\usage{
moderTest2grp(
  dat,
  grp,
  limmaOutput = TRUE,
  addResults = c("lfdr", "FDR", "Mval", "means"),
  testOrientation = "=",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{matrix or data.frame with rows for multiple (independent) tests, use ONLY with 2 groups; assumed as log2-data}

\item{grp}{(factor) describes column-relationship of 'dat'   (1st factor is considered as reference -> orientation of M-values !!)}

\item{limmaOutput}{(logical) return full (or extended) MArrayLM-object from limma or 'FALSE' for only the (uncorrected) p.values}

\item{addResults}{(character) types of results to add besides basic limma-output, data are assumed to be log2 ! (eg "lfdr" using fdrtool-package, "FDR" or "BH" for BH-FDR, "BY" for BY-FDR, 
"bonferroni" for Bonferroni-correction, "qValue" for lfdr by qvalue, "Mval", "means" or "nonMod" for non-moderated test and he equivaent all (other) multiple testing corrections chosen here)}

\item{testOrientation}{(character) for one-sided test (">","greater" or "<","less"), NOTE : 2nd grp is considered control/reference, '<' will identify grp1 < grp2}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a limma-type object of class \code{MArrayLM}
}
\description{
This function runs moderated t-test from package \code{limma} on each line of data.
Note: This function requires the package \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma} from bioconductor being installed. 
The \code{limma} contrast-matrix has to be read by column, the lines in the contrast-matrix containing '+1' will be compared to the '-1' lines, eg grpA-grpB .
Local false discovery rates (lfdr) estimations will be made using the CRAN-package \href{https://CRAN.R-project.org/package=fdrtool}{fdrtool} (if available).
}
\examples{
set.seed(2017); t8 <- matrix(round(rnorm(1600,10,0.4),2), ncol=8,
  dimnames=list(paste("l",1:200),c("AA1","BB1","CC1","DD1","AA2","BB2","CC2","DD2")))
t8[3:6,1:2] <- t8[3:6,1:2]+3     # augment lines 3:6 for AA1&BB1
t8[5:8,5:6] <- t8[5:8,5:6]+3     # augment lines 5:8 for AA2&BB2 (c,d,g,h should be found)
t4 <- log2(t8[,1:4]/t8[,5:8])
## Two-sided testing 
fit4 <- moderTest2grp(t4,gl(2,2))
# If you have limma installed we can now see further
if("list" \%in\% mode(fit4) & requireNamespace("limma")) {
  limma::topTable(fit4, coef=1, n=5)}    # effect for 3,4,7,8

## One-sided testing
fit4in <- moderTest2grp(t4,gl(2,2),testO="<")
# If you have limma installed we can now see further
if("list" \%in\% mode(fit4) & requireNamespace("limma")) {
  limma::topTable(fit4in, coef=1, n=5) }
}
\seealso{
\code{\link[limma]{lmFit}} and the \code{eBayes}-family of functions in package \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma}, \code{\link[stats]{p.adjust}}
}
