% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFragments.R
\name{makeFragments}
\alias{makeFragments}
\title{Make terminal and internal fragments from proteins}
\usage{
makeFragments(
  protTab,
  minFragSize = 6,
  maxFragSize = 300,
  internFra = TRUE,
  knownMods = NULL,
  redRedundSeq = FALSE,
  prefFragPat = NULL,
  remNonConfPrefFragm = TRUE,
  ambigLab = c(duplSequence = "duplSequence", isoMass = "isoMass"),
  massTy = "mono",
  specModif = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{protTab}{(character or matrix) named vector of protein-seqences to fragment or matrix (character) with lines for initial proteins/peptides, cols as name/sequence/mass}

\item{minFragSize}{(integer) minimum number of amino-acids for being considered}

\item{maxFragSize}{(integer) maximum number of amino-acids for being considered}

\item{internFra}{(logical) toggle if internal framents will be produced or not}

\item{knownMods}{(character) optional custom alternative to \code{AAfragSettings(ou="all")$knownMods}}

\item{redRedundSeq}{(logical) reduce redundant sequences to 1st appearance in all further treatments}

\item{prefFragPat}{(matrix) for preferential fragmentation rules (see also \code{.prefFragPattern})}

\item{remNonConfPrefFragm}{(logical) allows to remove (peptide-)fragments non conform with preferential fragmentation rules (using \code{evalIsoFragm})}

\item{ambigLab}{(character) text-labels for ambiguities (first for duplicated sequences second for iso-mass)}

\item{massTy}{(character) default 'mono' for mono-isotopic masses (alterative 'average')}

\item{specModif}{(list) supplemental custom fixed or variable modifications (eg Zn++ at given residue)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) for bug-tracking: more/enhanced messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix with fragment sequence, mass, start- and end-position, heading and tailing AA (or NA if terminal fragment)
}
\description{
Makes terminal and internal fragments based on protein-sequence and present as matrix including heading and/or tailing amino-acid or theoretical molecular mass of all fragments.
As the number of theoretically possible fragments increases with the size of the peptide/protein treated it is recommended to adopt arguments like \code{masFragSize} to 
realizstic values for the type of mass spectrometer used, since efficient filtering will reduce considerably the amount of memory (RAM) needed and will improve overal performance.
}
\examples{
protP <- c(protP="PEPTIDE")
pepT1 <- makeFragments(protTab=protP, minFragSize=2, maxFragSize=9, internFra=TRUE)
tail(pepT1)
}
\seealso{
\code{\link{makeFragments}};  \code{\link{evalIsoFragm}}, from package \href{https://CRAN.R-project.org/package=wrProteo}{wrProteo} \code{\link[wrProteo]{convAASeq2mass}}, \code{\link[wrProteo]{AAmass}}, \code{\link[wrProteo]{massDeFormula}}
}
