% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaDecode.R
\name{xegaGaGeneMapGray}
\alias{xegaGaGeneMapGray}
\title{Map the bit strings of a gray-coded gene to parameters in an interval.}
\usage{
xegaGaGeneMapGray(gene, penv)
}
\arguments{
\item{gene}{A binary gene (the genotype).}

\item{penv}{A problem environment.}
}
\value{
The decoded gene (the phenotype).
}
\description{
\code{xegaGaGenemapGray} maps the bit strings of 
             a binary string 
             interpreted as Gray codes to parameters in an interval.
             Bit vectors are mapped into equispaced numbers in the interval.
             Examples: Optimization of problems with real-valued 
                       parameter vectors.
}
\examples{
gene<-xegaGaInitGene(lFxegaGaGene)
xegaGaGeneMapGray(gene$gene1, lFxegaGaGene$penv)

}
\seealso{
Other Decoder: 
\code{\link{xegaGaDecodeGene}()},
\code{\link{xegaGaGeneMapIdentity}()},
\code{\link{xegaGaGeneMapPerm}()},
\code{\link{xegaGaGeneMap}()}
}
\concept{Decoder}
