% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaMutate.R
\name{xegaGaMutationFactory}
\alias{xegaGaMutationFactory}
\title{Configure the mutation function of a genetic algorithm.}
\usage{
xegaGaMutationFactory(method = "MutateGene")
}
\arguments{
\item{method}{A string specifying the mutation function.}
}
\value{
A mutation function for genes.
}
\description{
\code{xegaGaMutationFactory()} implements the selection
             of one of the mutation functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "MutateGene" returns \code{xegaGaMutateGene()}.
             \item "IVM" returns \code{xegaGaIVAdaptiveMutateGene()}.
             }
}
\examples{
parm<-function(x) {function() {return(x)}}
lFxegaGaGene$BitMutationRate1<-parm(1.0)
Mutate<-xegaGaMutationFactory("MutateGene")
gene1<-xegaGaInitGene(lFxegaGaGene)
gene1
Mutate(gene1, lFxegaGaGene)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaGaGene}},
\code{\link{xegaGaCrossoverFactory}()},
\code{\link{xegaGaGeneMapFactory}()},
\code{\link{xegaGaReplicationFactory}()}
}
\concept{Configuration}
