% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeCodonPrecision.R
\name{MinCodonPrecision}
\alias{MinCodonPrecision}
\title{Minimal precision of codon.}
\usage{
MinCodonPrecision(LHS, ...)
}
\arguments{
\item{LHS}{Vector of Integers. The left-hand side of a grammar object \code{G}.}

\item{...}{Unused. Needed for common abstract interface of 
precision functions.}
}
\value{
Integer.  The Precision of a codon whose upper bound is the least power of 2 
        above the maximum number of rules for a non-terminal of a grammar.
}
\description{
The minimal precision of the codon needed for generating a working 
             decoder for a context-free grammar \code{G}. However, the decoder 
             has some choice bias which reduces the efficiency of grammar evolution.
}
\examples{
NT<-sample(5, 50, replace=TRUE)
MinCodonPrecision(NT)
}
\seealso{
Other Precision: 
\code{\link{CodonPrecisionWithThreshold}()},
\code{\link{mLCMGCodonPrecision}()}
}
\concept{Precision}
