% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coredata.xts.R
\name{coredata.xts}
\alias{coredata.xts}
\alias{xcoredata}
\alias{xcoredata<-}
\title{Extract/Replace Core Data of an xts Object}
\usage{
\method{coredata}{xts}(x, fmt = FALSE, ...)

xcoredata(x, ...)

xcoredata(x) <- value
}
\arguments{
\item{x}{An xts object.}

\item{fmt}{Should the rownames be formated using \code{tformat()}? Alternatively
a date/time string to be passed to \code{format()}. See details.}

\item{\dots}{Unused.}

\item{value}{Non-core attributes to assign.}
}
\value{
Returns either a matrix object for coredata, or a list of named
attributes.

The replacement functions are called for their side-effects.
}
\description{
Mechanism to extract and replace the core data of an xts object.
}
\details{
Extract coredata of an xts object - removing all attributes except
\code{dim} and \code{dimnames} and returning a matrix object with rownames
converted from the index of the xts object.

The rownames of the result use the format specified by \code{tformat(x)} when
\code{fmt = TRUE}. When \code{fmt} is a character string to be passed to \code{format()}.
See \code{\link[=strptime]{strptime()}} for valid format strings. Setting \code{fmt = FALSE} will
return the row names by simply coercing the index class to a character
string in the default manner.

\code{xcoredata()} is the complement to \code{coredata()}. It returns all of the
attributes normally removed by \code{coredata()}.  Its purpose, along with the
the replacement function \verb{xcoredata<-} is primarily for developers using
\pkg{xts}' \code{\link[=try.xts]{try.xts()}} and \code{\link[=reclass]{reclass()}} functionality inside functions
so the functions can take any time series class as an input and return the
same time series class.
}
\examples{

data(sample_matrix)
x <- as.xts(sample_matrix, myattr=100)
coredata(x)
xcoredata(x)

}
\seealso{
\code{\link[zoo:zoo]{coredata()}}, \code{\link[=xtsAttributes]{xtsAttributes()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
