% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xts.R
\name{xts}
\alias{xts}
\alias{.xts}
\alias{is.xts}
\title{Create or Test For An xts Time-Series Object}
\usage{
xts(
  x = NULL,
  order.by = index(x),
  frequency = NULL,
  unique = TRUE,
  tzone = Sys.getenv("TZ"),
  ...
)

.xts(
  x = NULL,
  index,
  tclass = c("POSIXct", "POSIXt"),
  tzone = Sys.getenv("TZ"),
  check = TRUE,
  unique = FALSE,
  ...
)

is.xts(x)
}
\arguments{
\item{x}{An object containing the underlying data.}

\item{order.by}{A corresponding vector of dates/times of a known time-based
class. See Details.}

\item{frequency}{Numeric value indicating the frequency of \code{order.by}. See
details.}

\item{unique}{Can the index only include unique timestamps? Ignored when
\code{check = FALSE}.}

\item{tzone}{Time zone of the index (ignored for indices without a time
component, e.g. Date, yearmon, yearqtr). See \code{\link[=tzone]{tzone()}}.}

\item{\dots}{Additional attributes to be added. See details.}

\item{index}{A corresponding \emph{numeric} vector specified as seconds since
the UNIX epoch (1970-01-01 00:00:00.000).}

\item{tclass}{Time class to use for the index. See \code{\link[=tclass]{tclass()}}.}

\item{check}{Must the index be ordered? The index cannot contain duplicates
when \code{check = TRUE} and \code{unique = TRUE}.}
}
\value{
An S3 object of class xts.
}
\description{
Constructor function for creating an extensible time-series object.
}
\details{
\code{xts()} is used to create an xts object from raw data inputs. The xts class
inherits from and extends the zoo class, which means most zoo functions can
be used on xts objects.

The \code{xts()} constructor is the preferred way to create xts objects. It
performs several checks to ensure it returns a well-formed xts object. The
\code{.xts()} constructor is mainly for internal use. It is more efficient then
the regular \code{xts()} constructor because it doesn't perform as many validity
checks. Use it with caution.

Similar to zoo objects, xts objects must have an ordered index. While zoo
indexes cannot contain duplicate values, xts objects have optionally
supported duplicate index elements since version 0.5-0. The xts class has
one additional requirement: the index must be a time-based class. Currently
supported classes include: \sQuote{Date}, \sQuote{POSIXct}, \sQuote{timeDate},
as well as \sQuote{yearmon} and \sQuote{yearqtr} where the index values
remain unique.

The uniqueness requirement was relaxed in version 0.5-0, but is still
enforced by default. Setting \code{unique = FALSE} skips the uniqueness check and
only ensures that the index is ordered via the \code{isOrdered()} function.

As of version 0.10-0, xts no longer allows missing values in the index. This
is because many xts functions expect all index values to be finite. The most
important of these is \code{merge.xts()}, which is used ubiquitously. Missing
values in the index are usually the result of a date-time conversion error
(e.g. incorrect format, non-existent time due to daylight saving time, etc.).
Because of how non-finite numbers are represented, a missing timestamp will
always be at the end of the index (except if it is \code{-Inf}, which will be
first).

Another difference from \pkg{zoo} is that xts object may carry additional
attributes that may be desired in individual time-series handling. This
includes the ability to augment the objects data with meta-data otherwise
not cleanly attachable to a standard zoo object. These attributes may be
assigned and extracted via \code{\link[=xtsAttributes]{xtsAttributes()}} and \code{\link{xtsAttributes<-}},
respectively.

Examples of usage from finance may include the addition of data for keeping
track of sources, last-update times, financial instrument descriptions or
details, etc.

The idea behind \pkg{xts} is to offer the user the ability to utilize a
standard zoo object, while providing an mechanism to customize the object's
meta-data, as well as create custom methods to handle the object in a manner
required by the user.

Many xts-specific methods have been written to better handle the unique
aspects of xts. These include, subsetting (\code{[}), \code{merge()}, \code{cbind()},
\code{rbind()}, \code{c()}, math and logical operations, \code{lag()}, \code{diff()},
\code{coredata()}, \code{head()}, and \code{tail()}. There are also xts-specific methods
for converting to/from R's different time-series classes.

Subsetting via \code{[} methods offers the ability to specify dates by range, if
they are enclosed in quotes. The style borrows from python by creating
ranges separated by a double colon \dQuote{"::"} or \dQuote{"/"}. Each side
of the range may be left blank, which would then default to the start and
end of the data, respectively. To specify a subset of times, it is only
required that the time specified be in standard ISO format, with some form
of separation between the elements. The time must be \emph{left-filled}, that is
to specify a full year one needs only to provide the year, a month requires
the full year and the integer of the month requested - e.g. '1999-01'. This
format would extend all the way down to seconds - e.g. '1999-01-01 08:35:23'.
Leading zeros are not necessary. See the examples for more detail.

Users may also extend the xts class to new classes to allow for method
overloading.

Additional benefits derive from the use of \code{\link[=as.xts]{as.xts()}} and \code{\link[=reclass]{reclass()}},
which allow for lossless two-way conversion between common R time-series
classes and the xts object structure. See those functions for more detail.
}
\examples{

data(sample_matrix)
sample.xts <- as.xts(sample_matrix, descr='my new xts object')

class(sample.xts)
str(sample.xts)

head(sample.xts)  # attribute 'descr' hidden from view
attr(sample.xts,'descr')

sample.xts['2007']  # all of 2007
sample.xts['2007-03/']  # March 2007 to the end of the data set
sample.xts['2007-03/2007']  # March 2007 to the end of 2007
sample.xts['/'] # the whole data set
sample.xts['/2007'] # the beginning of the data through 2007
sample.xts['2007-01-03'] # just the 3rd of January 2007

}
\references{
\pkg{zoo}
}
\seealso{
\code{\link[=as.xts]{as.xts()}}, \code{\link[=index]{index()}}, \code{\link[=tclass]{tclass()}}, \code{\link[=tformat]{tformat()}}, \code{\link[=tzone]{tzone()}},
\code{\link[=xtsAttributes]{xtsAttributes()}}
}
\author{
Jeffrey A. Ryan and Joshua M. Ulrich
}
\keyword{utilities}
