% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojson.R
\name{opts_read_geojson}
\alias{opts_read_geojson}
\title{Options for reading in GeoJSON}
\usage{
opts_read_geojson(
  type = c("sf", "sfc"),
  property_promotion = c("string", "list"),
  property_promotion_lgl = c("integer", "string")
)
}
\arguments{
\item{type}{'sf' or 'sfc'}

\item{property_promotion}{What is the most general container type to use when
properties differ across a FEATURECOLLECTION?  E.g. if the property
exists both as a numeric and a string, should all values be promoted
to a 'string', or contained as different types in a 'list'.
Default: 'string' will behave like \code{geojsonsf} package.}

\item{property_promotion_lgl}{when \code{property_promotion = "string"}
should logical values become words (i.e. \code{"TRUE"}/\code{"FALSE"})
or integers (i.e. \code{"1"}/\code{"0"}).
Default: "integer" in order to match \code{geojsonsf} package}
}
\value{
Named list of options specific to reading GeoJSON
}
\description{
Options for reading in GeoJSON
}
\examples{
# Create a set of options to use when reading geojson
opts_read_geojson()
}
