% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_layers.R
\name{argentum_download_layers}
\alias{argentum_download_layers}
\title{Download WFS Layers to Folder}
\usage{
argentum_download_layers(
  organization,
  output_dir = file.path(tempdir(), "wfs_layers"),
  layer_names = NULL,
  format = c("gpkg", "shp", "geojson"),
  overwrite = FALSE
)
}
\arguments{
\item{organization}{A character string specifying the name of the organization}

\item{output_dir}{Path to the directory where files will be saved. Defaults to a temporary directory.}

\item{layer_names}{Optional vector of layer names to download. If NULL, downloads all available layers}

\item{format}{Output format for the files. One of "gpkg" (GeoPackage), "shp" (Shapefile),
or "geojson" (GeoJSON)}

\item{overwrite}{Logical; should existing files be overwritten?}
}
\value{
Invisibly returns a data frame with download results
}
\description{
This function downloads WFS layers from specified organizations to a local folder.
It can download all layers from an organization or specific layers by name.
}
\details{
Download WFS Layers to Folder
}
\examples{
\donttest{
# Get available organizations
orgs <- argentum_list_organizations()
if (nrow(orgs) > 0) {
  argentum_download_layers(orgs$Name[1], output_dir = tempdir())
}
}
}
