% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_exposure.R
\name{calculate_exposure}
\alias{calculate_exposure}
\title{Calculate Training Load Exposure (ATL, CTL, ACWR)}
\usage{
calculate_exposure(
  stoken,
  activity_type = c("Run", "Ride", "VirtualRide", "VirtualRun"),
  load_metric = "duration_mins",
  acute_period = 7,
  chronic_period = 42,
  user_ftp = NULL,
  user_max_hr = NULL,
  user_resting_hr = NULL,
  end_date = NULL
)
}
\arguments{
\item{stoken}{A valid Strava token from `rStrava::strava_oauth()`.}

\item{activity_type}{Type(s) of activities to include (e.g., "Run", "Ride").
Default includes common run/ride types.}

\item{load_metric}{Method for calculating daily load (e.g., "duration_mins",
"distance_km", "tss", "hrss"). Default "duration_mins".}

\item{acute_period}{Days for the acute load window (e.g., 7).}

\item{chronic_period}{Days for the chronic load window (e.g., 42). Must be greater than `acute_period`.}

\item{user_ftp}{Required if `load_metric = "tss"`. Your Functional Threshold Power.}

\item{user_max_hr}{Required if `load_metric = "hrss"`. Your maximum heart rate.}

\item{user_resting_hr}{Required if `load_metric = "hrss"`. Your resting heart rate.}

\item{end_date}{Optional. Analysis end date (YYYY-MM-DD string or Date). Defaults to today.
The analysis period covers the `chronic_period` days ending on this date.}
}
\value{
A data frame with columns: `date`, `daily_load`, `atl` (Acute Load),
  `ctl` (Chronic Load), and `acwr` (Acute:Chronic Ratio) for the analysis period.
}
\description{
Calculates training load metrics like ATL, CTL, and ACWR from Strava data.
}
\details{
Calculates daily load, ATL, CTL, and ACWR from Strava activities based on the chosen metric and periods.

Provides data for `plot_exposure`. Fetches extra prior data for
  accurate initial CTL. Requires FTP/HR parameters for TSS/HRSS metrics.
}
\examples{
# Example using simulated data
data(Athlytics_sample_data)
print(head(athlytics_sample_exposure))

\dontrun{
# Example using real data (requires authentication)
# Replace YOUR_APP, YOUR_ID, YOUR_SECRET with your Strava application details
# stoken_example <- rStrava::strava_oauth(app_name = "YOUR_APP",
#                                client_id = "YOUR_ID",
#                                client_secret = "YOUR_SECRET",
#                                cache = TRUE)

# Calculate training load for Rides using TSS
# Ensure stoken_example is defined and valid before running this part
# if (exists("stoken_example") && inherits(stoken_example, "Token2.0")) {
#   ride_exposure_tss <- calculate_exposure(
#     stoken = stoken_example,
#     activity_type = "Ride",
#     load_metric = "tss",
#     user_ftp = 280,
#     acute_period = 7,
#     chronic_period = 28
#   )
#   print(head(ride_exposure_tss))
#
#   # Calculate training load for Runs using HRSS
#   run_exposure_hrss <- calculate_exposure(
#       stoken = stoken_example,
#       activity_type = "Run",
#       load_metric = "hrss",
#       user_max_hr = 190,
#       user_resting_hr = 50
#   )
#   print(tail(run_exposure_hrss))
# } else {
#   message("stoken_example not created. Skipping real data examples for calculate_exposure.")
# }
}
}
