% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Ordinal.R
\name{AutoScore_weighting_Ordinal}
\alias{AutoScore_weighting_Ordinal}
\title{AutoScore STEP(iii) for ordinal outcomes: Generate the initial score
  with the final list of variables (Re-run AutoScore Modules 2+3)}
\usage{
AutoScore_weighting_Ordinal(
  train_set,
  validation_set,
  final_variables,
  link = "logit",
  max_score = 100,
  categorize = "quantile",
  quantiles = c(0, 0.05, 0.2, 0.8, 0.95, 1),
  max_cluster = 5,
  n_boot = 100
)
}
\arguments{
\item{train_set}{A processed \code{data.frame} that contains data to be analyzed, for training.}

\item{validation_set}{A processed \code{data.frame} that contains data for validation purpose.}

\item{final_variables}{A vector containing the list of selected variables,
selected from Step(ii) \code{\link{AutoScore_parsimony_Ordinal}}.}

\item{link}{The link function used to model ordinal outcomes. Default is
\code{"logit"} for proportional odds model. Other options are
\code{"cloglog"} (proportional hazards model) and \code{"probit"}.}

\item{max_score}{Maximum total score (Default: 100).}

\item{categorize}{Methods for categorize continuous variables. Options include "quantile" or "kmeans" (Default: "quantile").}

\item{quantiles}{Predefined quantiles to convert continuous variables to categorical ones. (Default: c(0, 0.05, 0.2, 0.8, 0.95, 1)) Available if \code{categorize = "quantile"}.}

\item{max_cluster}{The max number of cluster (Default: 5). Available if \code{categorize = "kmeans"}.}

\item{n_boot}{Number of bootstrap cycles to compute 95\% CI for performance
metrics.}
}
\value{
Generated \code{cut_vec} for downstream fine-tuning process STEP(iv)
  \code{\link{AutoScore_fine_tuning_Ordinal}}.
}
\description{
AutoScore STEP(iii) for ordinal outcomes: Generate the initial score
  with the final list of variables (Re-run AutoScore Modules 2+3)
}
\examples{
\dontrun{
data("sample_data_ordinal") # Output is named `label`
out_split <- split_data(data = sample_data_ordinal, ratio = c(0.7, 0.1, 0.2))
train_set <- out_split$train_set
validation_set <- out_split$validation_set
ranking <- AutoScore_rank_Ordinal(train_set, ntree=100)
num_var <- 6
final_variables <- names(ranking[1:num_var])
cut_vec <- AutoScore_weighting_Ordinal(
  train_set = train_set, validation_set = validation_set,
  final_variables = final_variables, max_score = 100,
  categorize = "quantile", quantiles = c(0, 0.05, 0.2, 0.8, 0.95, 1)
)
}
}
\references{
\itemize{
 \item{Saffari SE, Ning Y, Feng X, Chakraborty B, Volovici V, Vaughan R, Ong
       ME, Liu N, AutoScore-Ordinal: An interpretable machine learning framework for
       generating scoring models for ordinal outcomes, arXiv:2202.08407}
}
}
\seealso{
\code{\link{AutoScore_rank_Ordinal}},
  \code{\link{AutoScore_parsimony_Ordinal}},
  \code{\link{AutoScore_fine_tuning_Ordinal}},
  \code{\link{AutoScore_testing_Ordinal}}.
}
