% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_endpoint.R
\docType{class}
\name{AzureKeyVault}
\alias{AzureKeyVault}
\title{Azure Key Vault endpoint class}
\description{
Class representing the client endpoint for a key vault, exposing methods for working with it. Use the \verb{[key_vault]} function to instantiate new objects of this class.
}
\section{Fields}{

\itemize{
\item \code{keys}: A sub-object for working with encryption keys stored in the vault. See \link{keys}.
\item \code{secrets}: A sub-object for working with secrets stored in the vault. See \link{secrets}.
\item \code{certificates}: A sub-object for working with certificates stored in the vault. See \link{certificates}.
\item \code{storage}: A sub-object for working with storage accounts managed by the vault. See \link{storage}.
}
}

\examples{
\dontrun{

key_vault("mykeyvault")
key_vault("https://mykeyvault.vault.azure.net")

# authenticating as a service principal
key_vault("mykeyvault", tenant="myaadtenant", app="app_id", password="password")

# authenticating with an existing token
token <- AzureAuth::get_azure_token("https://vault.azure.net", "myaadtenant",
                                    app="app_id", password="password")
key_vault("mykeyvault", token=token)

}
}
\seealso{
\link{key_vault}, \link{keys}, \link{secrets}, \link{certificates}, \link{storage}

\href{https://learn.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://learn.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
