% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumry.lm.R
\name{sumry.lm}
\alias{sumry.lm}
\title{Method \code{sumry} to Summarize Linear Model (\code{lm}) Objects}
\usage{
\method{sumry}{lm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{lm}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An object of class \code{sumry.lm} containing tables and statistics described above.
}
\description{
Computes a comprehensive summary for an object of class \code{lm}, including performance statistics, ANOVA, coefficients with VIFs, and correlation/covariance tables. Handles factor variable recoding and collinearity/singularity warnings.
}
\details{
The returned \code{sumry} object includes:
\itemize{
  \item \strong{stats}: Performance statistics (F-statistic, R-squared, RMSE, etc.)
  \item \strong{anova}: Simplified ANOVA table (Sum of squares, mean squares, F-statistic, p-value)
  \item \strong{coefficients}: Table of regression coefficients with standard errors, t-stats, p-values, and VIFs
  \item \strong{cov.unscaled}, \strong{correlation}: Covariance and correlation matrices for coefficients
  \item \strong{v.correlation}: Variable correlation matrix (for models with interaction terms)
  \item \strong{fits}: Observed, fitted, and residual values
  \item \strong{aliased}: Logical vector indicating aliased coefficients
  \item \strong{df}: Degrees of freedom
  \item \strong{sigma}: Estimated standard deviation of residuals
  \item \strong{r.squared}, \strong{adj.r.squared}: R-squared and adjusted R-squared
  \item \strong{fstatistic}, \strong{f.pval}: F-statistic and p-value for overall regression
  \item \strong{notes}: Warnings, singularity, and collinearity notes (attached as attribute)
}
Factor variable names are recoded for clarity, and coefficients for aliased or singular variables are omitted with notes produced as attributes.
}
\examples{
mdl <- lm(Sepal.Length ~ Sepal.Width + Petal.Length, data = iris)
sumry(mdl)

}
\seealso{
\code{\link{print.sumry.lm}}, \code{\link{lm}}
}
