% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.build}
\alias{kernel.build}
\title{Build kernel hypervolumes.}
\usage{
kernel.build(comm, trait, method.hv = "gaussian", abund = TRUE, cores = 1, ...)
}
\arguments{
\item{comm}{A sites x species matrix, data.frame or vector, with incidence or abundance data about the species in the community.}

\item{trait}{A trait matrix, often resulting from hyper.build.}

\item{method.hv}{Method for constructing the 'Hypervolume' object. One of "gaussian" (Gaussian kernel density estimation, default), "box" (box kernel density estimation), or "svm" (one-class support vector machine). See respective functions of the hypervolume R package for details.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used as weights in hypervolume construction. Only works if method.hv = "gaussian".}

\item{cores}{Number of cores to be used in parallel processing. If = 0 all available cores are used. Beware that multicore for Windows is not optimized yet and it often takes longer than single core.}

\item{...}{further arguments to be passed to hypervolume::hypervolume}
}
\value{
A 'Hypervolume' or 'HypervolumeList', representing the hypervolumes of each community.
}
\description{
Builds kernel density n-dimensional hypervolumes from trait data.
}
\examples{
\dontrun{
comm = rbind(c(1,1,0,5,1), c(3,2,5,0,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site1", "Site2")

trait = data.frame(body = c(1,2,3,1,2), beak = c(1,2,4,2,1))
rownames(trait) = colnames(comm)

distance = gower(trait)
trait = hyper.build(distance)

hv = kernel.build(comm[1,], trait)
plot(hv)
hvlist = kernel.build(comm, trait, abund = FALSE, cores = 0)
plot(hvlist)
hvlist = kernel.build(comm, trait, method.hv = "box", cores = 2)
plot(hvlist)
}
}
