% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_sum.R
\name{pcor_sum}
\alias{pcor_sum}
\title{Partial Correlation Sum}
\usage{
pcor_sum(..., iter = NULL, relations)
}
\arguments{
\item{...}{An object of class \code{estimate}. This can be either one or two fitted objects.}

\item{iter}{Number of iterations (posterior samples; defaults to the number in the object).}

\item{relations}{Character string. Which partial correlations should be summed?}
}
\value{
An object of class \code{posterior_sum}, including the sum and possibly the difference for
two sums.
}
\description{
Compute and test partial correlation sums either within or between GGMs
(e.g., different groups), resulting in a posterior distribution.
}
\details{
Some care must be taken when writing the string for \code{partial_sum}. Below are several examples

\strong{Just a Sum}:
Perhaps a sum is of interest, and not necessarily the difference of two sums. This can be written as

\itemize{
\item \code{partial_sum <-  c("A1--A2 + A1--A3 + A1--A4")}
}

which will sum those relations.

\strong{Comparing Sums}:
When comparing sums, each must be seperated by "\code{;}". For example,

\itemize{
\item \code{partial_sum <-  c("A1--A2 + A1--A3; A1--A2 + A1--A4")}
}

which will sum both and compute the difference. Note that there cannot be more than two sums, such
that \code{c("A1--A2 + A1--A3; A1--A2 + A1--A4; A1--A2 + A1--A5")} will result in an error.

\strong{Comparing Groups}:

When more than one fitted object is suppled to \code{object} it is assumed that the groups
should be compared for the same sum. Hence, in this case, only the sum needs to be written.

\itemize{
\item \code{partial_sum <-  c("A1--A2 + A1--A3 + A1--A4")}
}

The above results in that sum being computed for each group and then compared.
}
\examples{
\donttest{
# data
Y <- bfi

# males
Y_males <- subset(Y, gender == 1, select = -c(education, gender))[,1:5]

# females
Y_females <- subset(Y, gender == 2, select = -c(education, gender))[,1:5]

# males
fit_males <- estimate(Y_males, seed = 1,
                      progress = FALSE)

# fit females
fit_females <- estimate(Y_females, seed = 2,
                        progress = FALSE)


sums <- pcor_sum(fit_males,
                 fit_females,
                 relations = "A1--A2 + A1--A3")
# print
sums

# plot difference
plot(sums)[[3]]
}
}
