% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callRelatedness.R
\name{callRelatedness}
\alias{callRelatedness}
\title{callRelatedness}
\usage{
callRelatedness(
  pmr_tibble,
  class_prior = rep(0.25, 4),
  average_relatedness = NULL,
  median_co = 500,
  filter_n = 1
)
}
\arguments{
\item{pmr_tibble}{a tibble that is the output of the processEigenstrat
function.}

\item{class_prior}{the prior probabilities for same/twin, 1st-degree,
2nd-degree, unrelated, respectively.}

\item{average_relatedness}{a single numeric value, or a vector of numeric
values, to use as the average background relatedness. If NULL, the sample
median is used.}

\item{median_co}{if average_relatedness is left NULL, then the minimum cutoff
for the number of overlapping snps to be included in the median calculation
is 500.}

\item{filter_n}{the minimum number of overlapping SNPs for which pairs are
removed from the entire analysis. If NULL, default is 1.}
}
\value{
results_tibble: A tibble containing 13 columns:
\itemize{
\item row: The row number
\item pair: the pair of individuals that are compared.
\item relationship: the highest posterior probability estimate of the degree of relatedness.
\item pmr: the pairwise mismatch rate (mismatch/nsnps).
\item sd: the estimated standard deviation of the pmr.
\item mismatch: the number of sites which did not match for each pair.
\item nsnps: the number of overlapping snps that were compared for each pair.
\item ave_re;: the value for the background relatedness used for normalisation.
\item Same_Twins: the posterior probability associated with a same individual/twins classification.
\item First_Degree: the posterior probability associated with a first-degree classification.
\item Second_Degree: the posterior probability associated with a second-degree classification.
\item Unrelated: the posterior probability associated with an unrelated classification.
\item BF: A strength of confidence in the Bayes Factor associated with the highest posterior probability classification compared to the 2nd highest. (No longer included)
}
}
\description{
A function that takes PMR observations, and (given a prior distribution for
degrees of relatedness) returns the posterior probabilities of all pairs of
individuals being (a) the same individual/twins, (b) first-degree related,
(c) second-degree related or (d) "unrelated" (third-degree or higher).
The highest posterior probability degree of relatedness is also returned as
a hard classification.
Options include setting the background relatedness (or using the sample
median), a minimum number of overlapping SNPs if one uses the sample median
for background relatedness, and a minimum number of overlapping SNPs
for including pairs in the analysis.
}
\examples{
callRelatedness(counts_example,
  class_prior=rep(0.25,4),
  average_relatedness=NULL,
  median_co=5e2,filter_n=1
)
}
