% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_inference.R
\name{plot_spatial_param}
\alias{plot_spatial_param}
\title{Plot the spatially-dependent parameter for in-sample locations.}
\usage{
plot_spatial_param(
  out,
  parameter,
  loadings = 1,
  type = "mean",
  ci.level = c(0.025, 0.975),
  yearscale = TRUE,
  color.gradient = (grDevices::colorRampPalette(rev(RColorBrewer::brewer.pal(9, name =
    "RdBu"))))(50)
)
}
\arguments{
\item{out}{Output from BSTFA or BSTFAfull.}

\item{parameter}{One of \code{'slope'} (default), \code{'loading'}, or \code{'mean'}.}

\item{loadings}{If \code{parameter='loading'}, an integer indicating which factor loading to plot.}

\item{type}{One of \code{mean} (default), \code{median}, \code{ub}, or \code{lb} indicating which summary statistic to plot at each location.}

\item{ci.level}{If \code{type='lb'} or \code{'ub'}, the percentiles for the posterior interval.}

\item{yearscale}{If \code{parameter='slope'}, a logical scalar indicating whether to translate it to a yearly scale (\code{TRUE}; default).}

\item{color.gradient}{The color palette to use for the plot.  Default is \code{colorRampPalette(rev(RColorBrewer::brewer.pal(9, name='RdBu')))(50)}.}
}
\value{
A plot of spatially-dependent parameter values for the observed locations.
}
\description{
Plot the spatially-dependent parameter for in-sample locations.
}
\examples{
data(out.sm)
attach(out.sm)
plot_spatial_param(out.sm, parameter='slope')
}
\author{
Adam Simpson and Candace Berrett
}
