% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrainMap.R
\name{BrainMap}
\alias{BrainMap}
\title{Bayesian brain mapping}
\usage{
BrainMap(
  BOLD,
  prior,
  tvar_method = c("non-negative", "unbiased"),
  scale = c("prior", "global", "local", "none"),
  scale_sm_surfL = NULL,
  scale_sm_surfR = NULL,
  scale_sm_FWHM = "prior",
  nuisance = NULL,
  scrub = NULL,
  drop_first = 0,
  hpf = "prior",
  TR = NULL,
  GSR = "prior",
  Q2 = "prior",
  Q2_max = "prior",
  covariates = NULL,
  brainstructures = "prior",
  mask = NULL,
  varTol = "prior",
  spatial_model = NULL,
  resamp_res = NULL,
  rm_mwall = TRUE,
  reduce_dim = FALSE,
  method_FC = c("VB1", "VB2", "none"),
  maxiter = 100,
  miniter = 3,
  epsilon = 0.001,
  kappa_init = 0.2,
  usePar = TRUE,
  PW = FALSE,
  seed = 1234,
  verbose = TRUE
)
}
\arguments{
\item{BOLD}{Vector of subject-level fMRI data in one of the following
formats: CIFTI file paths, \code{"xifti"} objects, NIFTI file paths,
\code{"nifti"} objects, or \eqn{V \times T} numeric matrices, where \eqn{V}
is the number of data locations and \eqn{T} is the number of timepoints.

If multiple BOLD data are provided, they will be independently centered,
scaled, detrended (if applicable), and denoised (if applicable). Then they
will be concatenated together followed by computing the initial dual
regression estimate.}

\item{prior}{Prior estimates in a format compatible with \code{BOLD},
from \code{\link{estimate_prior}}.}

\item{tvar_method}{Which calculation of the prior variance to use:
\code{"non-negative"} (default) or \code{"unbiased"}. The unbiased prior
variance is based on the assumed mixed effects/ANOVA model, whereas the
non-negative prior variance adds to it to account for greater potential
between-subjects variation. (The prior mean is the same for either choice
of \code{tvar_method}.)}

\item{scale}{\code{"global"}, \code{"local"}, or \code{"none"}.
Global scaling will divide the entire data matrix by the mean image standard
deviation (\code{mean(sqrt(rowVars(BOLD)))}). Local scaling will divide each
data location's time series by its estimated standard deviation. Default:
\code{"prior"}, to use the same option used for estimation of the
\code{prior}.}

\item{scale_sm_surfL, scale_sm_surfR, scale_sm_FWHM}{Only applies if
\code{scale=="local"} and \code{BOLD} represents CIFTI-format data. To
smooth the standard deviation estimates used for local scaling, provide the
surface geometries along which to smooth as GIFTI geometry files or
\code{"surf"} objects, as well as the smoothing FWHM (default:
\code{"prior"} to use the same option used for estimation of the
\code{prior}).

If \code{scale_sm_FWHM==0}, no smoothing of the local standard deviation
estimates will be performed.

If \code{scale_sm_FWHM>0} but \code{scale_sm_surfL} and
\code{scale_sm_surfR} are not provided, the default inflated surfaces from
the HCP will be used.

To create a \code{"surf"} object from data, see
\code{\link[ciftiTools]{make_surf}}. The surfaces must be in the same
resolution as the \code{BOLD} data.}

\item{nuisance}{(Optional) Signals to regress from the data, given as a
numeric matrix with the same number of rows as there are volumes in the
\code{BOLD} data. If multiple \code{BOLD} sessions are provided,
this argument can be a list to use different nuisance regressors for
different sessions. Nuisance regression is performed as a first step, before
centering, scaling, and denoising. An intercept column will automatically be
added to \code{nuisance}. If \code{NULL}, no extra nuisance signals will be
regressed from the data, but a nuisance regression will still be used if
warranted by \code{scrub} or \code{hpf}.}

\item{scrub}{(Optional) A numeric vector of integers giving the indices
of volumes to scrub from the BOLD data. (List the volumes to remove, not the
ones to keep.) If multiple \code{BOLD} sessions are provided, this
argument can be a list to remove different volumes for different sessions.
Scrubbing is performed within nuisance regression by adding a spike
regressor to the nuisance design matrix for each volume to scrub. If
\code{NULL} (default), do not scrub.}

\item{drop_first}{(Optional) Number of volumes to drop from the start of each
BOLD session. Default: \code{0}.}

\item{TR, hpf}{These arguments control detrending. \code{TR} is the temporal
resolution of the data, i.e. the time between volumes, in seconds;
\code{hpf} is the frequency of the high-pass filter, in Hertz. Detrending
is performed via nuisance regression of DCT bases. Default:
\code{"prior"} to use the values from the prior. Be sure to set the
correct \code{TR} if it's different for the new data compared to the data
used in \code{estimate_prior}.

Note that if multiple \code{BOLD} sessions are provided, their
\code{TR} and \code{hpf} must be the same; both arguments accept only one
value.}

\item{GSR}{Center BOLD across columns (each image)? This
is equivalent to performing global signal regression. Default:
\code{"prior"}, to use the same option used for estimation of the
\code{prior}.}

\item{Q2, Q2_max}{Denoise the BOLD data? Denoising is based on modeling and
removing nuisance ICs. It may result in a cleaner estimate for smaller
datasets, but it may be unnecessary (and time-consuming) for larger datasets.

Set \code{Q2} to control denoising: use a positive integer to specify the
number of nuisance ICs, \code{NULL} to have the number of nuisance ICs
estimated by PESEL, or zero to skip denoising.

If \code{is.null(Q2)}, use \code{Q2_max} to specify the maximum number of
nuisance ICs that should be estimated by PESEL. \code{Q2_max} must be less
than \eqn{T * .75 - Q} where \eqn{T} is the number of timepoints in BOLD
and \eqn{Q} is the number of networks in the prior. If \code{NULL}, \code{Q2_max}
will be set to \eqn{T * .50 - Q}, rounded.

The defaults for both arguments is \code{"prior"}, to use the same option
used for estimation of the \code{prior}.}

\item{covariates}{Numeric vector of covariates to take into account for model
estimation. Names should give the name of each variable. The covariates must
match those of the prior. Default: \code{NULL} (no covariates).
NOTE: Not implemented yet.}

\item{brainstructures}{Only applies if the entries of \code{BOLD} are CIFTI
file paths. This is a character vector indicating which brain structure(s)
to obtain: \code{"left"} (left cortical surface), \code{"right"} (right
cortical surface) and/or \code{"subcortical"} (subcortical and cerebellar
gray matter). Can also be \code{"all"} (obtain all three brain structures).
Default: \code{"prior"} to use the same brainstructures present in the
\code{prior}).}

\item{mask}{Required only if the entries of \code{BOLD} are NIFTI
file paths or \code{"nifti"} objects. This is a binary array of the same
spatial dimensions as the fMRI data, with \code{TRUE} corresponding to
in-mask voxels.}

\item{varTol}{Tolerance for variance of each data location. For each scan,
locations which do not meet this threshold are masked out of the analysis.
Default: \code{"prior"} to use the same brainstructures present in the
\code{prior}). Variance is calculated on the original data, before
any normalization. Set to \code{0} to avoid removing locations due to
low variance.}

\item{spatial_model}{Should spatial modeling be performed? If \code{NULL}, assume
spatial independence. Otherwise, provide meshes specifying the spatial priors assumed on
each independent component. Each should represent a brain structure, between which
spatial independence can be assumed.

If \code{BOLD} represents CIFTI-format data, \code{spatial_model} should give the left and
right cortex surface geometries (whichever one(s) are being used) as \code{"surf"}
objects or GIFTI surface geometry file paths. Spatial modeling is not yet available for
the subcortex. This argument can also be \code{TRUE}, in which case spatial modeling
will be performed with the surfaces included in the first entry of \code{BOLD} if it is a
\code{"xifti"} object, or if those are not present available, the default inflated
surfaces from \code{ciftiTools}.

If \code{BOLD} represents NIFTI-format data, spatial modeling is not yet available.

If \code{BOLD} is a numeric matrix, \code{spatial_model} should be a list of meshes
(see \code{\link{make_mesh}}).}

\item{resamp_res}{Only applies if \code{BOLD} represents CIFTI-format data.
The target resolution for resampling (number of cortical surface vertices
per hemisphere). For spatial modelling, a value less than 10000 is
recommended for computational feasibility. If \code{NULL} (default), do not
perform resampling.}

\item{rm_mwall}{Only applies if \code{BOLD} represents CIFTI-format data.
Should medial wall (missing data) locations be removed from the mesh?
If \code{TRUE}, faster computation but less accurate estimates at the
boundary of wall.}

\item{reduce_dim}{Reduce the temporal dimension of the data using PCA?
Default: \code{TRUE}. Skipping dimension reduction will slow the model
estimation, but may result in more accurate results. Ignored for FC prior
ICA}

\item{method_FC}{Variational Bayes (VB) method for FC prior ICA model:
\code{"VB1"} (default) uses a conjugate Inverse-Wishart prior for the cor(A);
\code{"VB2"} draws samples from p(cor(A)) to emulate the population distribution
using a combination of Cholesky, SVD, and random pivoting.
\code{"none"} Uses standard prior ICA without FC prior}

\item{maxiter}{Maximum number of EM or VB iterations. Default: \code{100}.}

\item{miniter}{Minimum number of EM or VB iterations. Default: \code{3}.}

\item{epsilon}{Smallest proportion change between iterations. Default:
\code{.001}.}

\item{kappa_init}{Starting value for kappa. Default: \code{0.2}.}

\item{usePar}{Parallelize the computation? Default: \code{TRUE}. Can be the
number of cores to use or \code{TRUE}, which will use the number available minus two.}

\item{PW}{Prewhiten to account for residual autocorrelation? Default: \code{FALSE}.
Only affects FC prior ICA models.}

\item{seed}{(Only applicable for FC calculation and if \code{PW}) Seed to use
for computing temporal effective sample size (ESS) to correct sums over
\eqn{t}. If \code{NULL}, do not change the seed. Default: \code{1234}.}

\item{verbose}{If \code{TRUE}, display progress of algorithm}
}
\value{
A (spatial) prior ICA object, which is a list containing:
\code{subjNet_mean}, the \eqn{V \times L} estimated independent components
\strong{S}; \code{subjNet_se}, the standard errors of \strong{S}; the
\code{mask} of locations without prior values due to too many low
variance or missing values; the \code{nuisance} design matrix or matrices if
applicable; and the function \code{params} such as the type of scaling and
detrending performed.

If \code{BOLD} represented CIFTI or NIFTI data, \code{subjNet_mean} and
\code{subjNet_se} will be formatted as \code{"xifti"} or \code{"nifti"}
objects, respectively.
}
\description{
Fit Bayesian brain mapping model using variational Bayes (VB) or
expectation-maximization (EM).
}
\examples{
\dontrun{
 tm <- estimate_prior(cii1_fnames, cii2_fnames, gICA_fname, usePar=FALSE)
 BrainMap(newcii_fname, tm, spatial_model=TRUE, resamp_res=2000, usePar=FALSE)
}
}
