% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_prior.methods.R
\name{plot.prior.nifti}
\alias{plot.prior.nifti}
\title{Plot prior}
\usage{
\method{plot}{prior.nifti}(
  x,
  stat = c("mean", "sd", "var"),
  plane = c("axial", "sagittal", "coronal"),
  n_slices = 9,
  slices = NULL,
  var_method = c("non-negative", "unbiased"),
  ...
)
}
\arguments{
\item{x}{The prior from \code{estimate_prior.nifti}}

\item{stat}{\code{"mean"} (default), \code{"sd"}, or \code{"var"}.
(\code{"sd"} will show the square root of the variance prior.)}

\item{plane, n_slices, slices}{Anatomical plane and which slice indices to
show.
Default: 9 axial slices.}

\item{var_method}{\code{"non-negative"} (default) or \code{"unbiased"}}

\item{...}{Additional arguments to \code{oro.nifti::image}}
}
\value{
The plot
}
\description{
Based on \code{oro.nifti::image}.
}
\details{
Consider using \code{struct_prior} to obtain the 3D volumes to plot with a different
viewer function (e.g. from \code{oro.nifti}) if desired.
}
